/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearches;

public class SimpleMessageSearchIndex<Id>
implements MessageSearchIndex<Id> {
    private final MessageMapperFactory<Id> factory;

    public SimpleMessageSearchIndex(MessageMapperFactory<Id> factory) {
        this.factory = factory;
    }

    @Override
    public Iterator<Long> search(MailboxSession session, Mailbox<Id> mailbox, SearchQuery query) throws MailboxException {
        List crits = query.getCriterias();
        MessageMapper<Id> mapper = this.factory.getMessageMapper(session);
        if (crits.size() == 1 && crits.get(0) instanceof SearchQuery.UidCriterion) {
            final ArrayList uids = new ArrayList();
            SearchQuery.UidCriterion uidCrit = (SearchQuery.UidCriterion)crits.get(0);
            SearchQuery.NumericRange[] ranges = uidCrit.getOperator().getRange();
            for (int i = 0; i < ranges.length; ++i) {
                SearchQuery.NumericRange r = ranges[i];
                mapper.findInMailbox(mailbox, MessageRange.range((long)r.getLowValue(), (long)r.getHighValue()), MessageMapper.FetchType.Metadata, new MessageMapper.MessageCallback<Id>(){

                    @Override
                    public void onMessages(List<Message<Id>> list) throws MailboxException {
                        for (int i = 0; i < list.size(); ++i) {
                            long uid = list.get(i).getUid();
                            if (uids.contains(uid)) continue;
                            uids.add(uid);
                        }
                    }
                });
            }
            Collections.sort(uids);
            return uids.iterator();
        }
        final ArrayList hits = new ArrayList();
        mapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, new MessageMapper.MessageCallback<Id>(){

            @Override
            public void onMessages(List<Message<Id>> list) throws MailboxException {
                for (int i = 0; i < list.size(); ++i) {
                    Message m = list.get(i);
                    if (hits.contains(m)) continue;
                    hits.add(m);
                }
            }
        });
        Collections.sort(hits);
        Iterator it = new Iterator<Message<?>>(){
            final Iterator<Message<Id>> it;
            {
                this.it = hits.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Message<?> next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
        if (session == null) {
            return new MessageSearches(it, query).iterator();
        }
        return new MessageSearches(it, query, session.getLog()).iterator();
    }
}

