/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.Message;

public abstract class AbstractHeaderComparator
implements Comparator<Message<?>> {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String CC = "cc";

    protected String getHeaderValue(String headerName, Message<?> message) {
        try {
            List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
            for (MessageResult.Header header : headers) {
                try {
                    String name = header.getName();
                    if (!headerName.equalsIgnoreCase(name)) continue;
                    String value = header.getValue();
                    return value.toUpperCase(Locale.ENGLISH);
                }
                catch (MailboxException e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }
}

