/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.james.mailbox.SearchQuery;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.comparator.BaseSubjectComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderDisplayComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderMailboxComparator;
import org.apache.james.mailbox.store.search.comparator.InternalDateComparator;
import org.apache.james.mailbox.store.search.comparator.SentDateComparator;
import org.apache.james.mailbox.store.search.comparator.SizeComparator;
import org.apache.james.mailbox.store.search.comparator.UidComparator;

public class CombinedComparator
implements Comparator<Message<?>> {
    private final Comparator<Message<?>>[] comparators;

    public CombinedComparator(Comparator<Message<?>>[] comparators) {
        if (comparators == null || comparators.length < 1) {
            throw new IllegalArgumentException();
        }
        this.comparators = comparators;
    }

    @Override
    public int compare(Message<?> o1, Message<?> o2) {
        int i = 0;
        for (int a = 0; a < this.comparators.length && (i = this.comparators[a].compare(o1, o2)) == 0; ++a) {
        }
        return i;
    }

    public static Comparator<Message<?>> create(List<SearchQuery.Sort> sorts) {
        ArrayList comps = new ArrayList();
        for (int i = 0; i < sorts.size(); ++i) {
            SearchQuery.Sort sort = sorts.get(i);
            boolean reverse = sort.isReverse();
            Comparator<Message<?>> comparator = null;
            switch (sort.getSortClause()) {
                case Arrival: {
                    comparator = InternalDateComparator.internalDate(reverse);
                    break;
                }
                case MailboxCc: {
                    comparator = HeaderMailboxComparator.cc(reverse);
                    break;
                }
                case MailboxFrom: {
                    comparator = HeaderMailboxComparator.from(reverse);
                    break;
                }
                case Size: {
                    comparator = SizeComparator.size(reverse);
                    break;
                }
                case BaseSubject: {
                    comparator = BaseSubjectComparator.baseSubject(reverse);
                    break;
                }
                case MailboxTo: {
                    comparator = HeaderMailboxComparator.to(reverse);
                    break;
                }
                case Uid: {
                    comparator = UidComparator.uid(reverse);
                    break;
                }
                case SentDate: {
                    comparator = SentDateComparator.sentDate(reverse);
                }
                case DisplayFrom: {
                    comparator = HeaderDisplayComparator.from(reverse);
                    break;
                }
                case DisplayTo: {
                    comparator = HeaderDisplayComparator.to(reverse);
                    break;
                }
            }
            if (comparator == null) continue;
            comps.add(comparator);
        }
        return new CombinedComparator(comps.toArray(new Comparator[0]));
    }
}

