/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.util.Comparator;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;
import org.apache.james.mailbox.store.search.comparator.ReverseComparator;

public class HeaderMailboxComparator
extends AbstractHeaderComparator {
    private final String headerName;
    private static final Comparator<Message<?>> FROM_COMPARATOR = new HeaderMailboxComparator("from");
    private static final Comparator<Message<?>> REVERSE_FROM_COMPARATOR = new ReverseComparator(FROM_COMPARATOR);
    private static final Comparator<Message<?>> TO_COMPARATOR = new HeaderMailboxComparator("to");
    private static final Comparator<Message<?>> REVERSE_TO_COMPARATOR = new ReverseComparator(TO_COMPARATOR);
    private static final Comparator<Message<?>> CC_COMPARATOR = new HeaderMailboxComparator("cc");
    private static final Comparator<Message<?>> REVERSE_CC_COMPARATOR = new ReverseComparator(CC_COMPARATOR);

    public HeaderMailboxComparator(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public int compare(Message<?> o1, Message<?> o2) {
        String mailbox1 = SearchUtil.getMailboxAddress(this.getHeaderValue(this.headerName, o1));
        String mailbox2 = SearchUtil.getMailboxAddress(this.getHeaderValue(this.headerName, o2));
        return mailbox1.compareToIgnoreCase(mailbox2);
    }

    public static Comparator<Message<?>> from(boolean reverse) {
        if (reverse) {
            return REVERSE_FROM_COMPARATOR;
        }
        return FROM_COMPARATOR;
    }

    public static Comparator<Message<?>> cc(boolean reverse) {
        if (reverse) {
            return REVERSE_CC_COMPARATOR;
        }
        return CC_COMPARATOR;
    }

    public static Comparator<Message<?>> to(boolean reverse) {
        if (reverse) {
            return REVERSE_TO_COMPARATOR;
        }
        return TO_COMPARATOR;
    }
}

