/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.Date;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;
import org.apache.james.mailbox.store.search.comparator.ReverseComparator;
import org.apache.james.mailbox.store.search.comparator.UidComparator;
import org.apache.james.mime4j.field.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;

public class SentDateComparator
extends AbstractHeaderComparator {
    private static final Comparator<Message<?>> SENTDATE = new SentDateComparator(false);
    private static final Comparator<Message<?>> REVERSE_SENTDATE = new ReverseComparator(new SentDateComparator(true));
    private final boolean reverse;

    public SentDateComparator(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public int compare(Message<?> o1, Message<?> o2) {
        Date date2;
        Date date1 = this.getSentDate(o1);
        int i = date1.compareTo(date2 = this.getSentDate(o2));
        if (i == 0) {
            return UidComparator.uid(this.reverse).compare(o1, o2);
        }
        return 0;
    }

    private Date getSentDate(Message<?> message) {
        String value = this.getHeaderValue("Date", message);
        StringReader reader = new StringReader(value);
        try {
            DateTime dateTime = new DateTimeParser((Reader)reader).parseAll();
            return dateTime.getDate();
        }
        catch (ParseException e) {
            return message.getInternalDate();
        }
    }

    public static Comparator<Message<?>> sentDate(boolean reverse) {
        if (reverse) {
            return REVERSE_SENTDATE;
        }
        return SENTDATE;
    }
}

