/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.store.ResultUtils;

public abstract class AbstractFullContent
implements Content {
    private List<MessageResult.Header> headers;

    public AbstractFullContent(List<MessageResult.Header> headers) throws IOException {
        this.headers = headers;
    }

    protected long caculateSize() throws IOException {
        long result = this.getBodySize();
        result += 2L;
        for (MessageResult.Header header : this.headers) {
            if (header == null) continue;
            result += header.size();
            result += 2L;
        }
        return result;
    }

    public final void writeTo(WritableByteChannel channel) throws IOException {
        ByteBuffer newLine = ByteBuffer.wrap(ResultUtils.BYTES_NEW_LINE);
        for (MessageResult.Header header : this.headers) {
            if (header != null) {
                header.writeTo(channel);
            }
            newLine.rewind();
            this.writeAll(channel, newLine);
        }
        newLine.rewind();
        this.writeAll(channel, newLine);
        this.bodyWriteTo(channel);
    }

    protected void writeAll(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (channel.write(buffer) > 0) {
        }
    }

    protected abstract long getBodySize() throws IOException;

    protected abstract void bodyWriteTo(WritableByteChannel var1) throws IOException;
}

