/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.store.streaming.AbstractFullContent;

public final class FullByteContent
extends AbstractFullContent {
    private final ByteBuffer contents;
    private final long size;

    public FullByteContent(ByteBuffer contents, List<MessageResult.Header> headers) throws IOException {
        super(headers);
        this.contents = contents;
        this.size = this.caculateSize();
    }

    public long size() {
        return this.size;
    }

    @Override
    protected void bodyWriteTo(WritableByteChannel channel) throws IOException {
        this.contents.rewind();
        this.writeAll(channel, this.contents);
    }

    @Override
    protected long getBodySize() throws IOException {
        return this.contents.limit();
    }
}

