/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.streaming.LazySkippingInputStream;

public final class InputStreamContent
implements org.apache.james.mailbox.InputStreamContent {
    private Message<?> m;
    private Type type;

    public InputStreamContent(Message<?> m, Type type) throws IOException {
        this.m = m;
        this.type = type;
    }

    public long size() {
        switch (this.type) {
            case Full: {
                return this.m.getFullContentOctets();
            }
        }
        return this.m.getBodyOctets();
    }

    public InputStream getInputStream() throws IOException {
        switch (this.type) {
            case Full: {
                return new BoundedInputStream(ResultUtils.toInput(this.m), this.size());
            }
        }
        return new BoundedInputStream(this.m.getBodyContent(), this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(WritableByteChannel channel) throws IOException {
        InputStream in = null;
        InputStream wrapped = null;
        long skipped = 0L;
        try {
            switch (this.type) {
                case Full: {
                    in = ResultUtils.toInput(this.m);
                    break;
                }
                default: {
                    in = this.m.getBodyContent();
                }
            }
            if (in instanceof LazySkippingInputStream) {
                skipped = ((LazySkippingInputStream)in).getSkippedBytes();
                wrapped = ((LazySkippingInputStream)in).getWrapped();
            } else {
                wrapped = in;
            }
            if (wrapped instanceof FileInputStream) {
                FileChannel fileChannel = ((FileInputStream)wrapped).getChannel();
                fileChannel.transferTo(skipped, fileChannel.size(), channel);
                fileChannel.close();
            } else {
                int i = 0;
                byte[] buf = new byte[16384];
                while ((i = in.read(buf)) != -1) {
                    ByteBuffer buffer = ByteBuffer.wrap(buf);
                    buffer.limit(i);
                    channel.write(buffer);
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (wrapped != null) {
                try {
                    wrapped.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static enum Type {
        Full,
        Body;

    }
}

