/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class LazySkippingInputStream
extends FilterInputStream {
    private long skipBytes;
    private boolean skipped = false;

    public LazySkippingInputStream(InputStream in, long skipBytes) {
        super(in);
        this.skipBytes = skipBytes;
    }

    @Override
    public int read() throws IOException {
        this.skipIfNeeded();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.skipIfNeeded();
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.skipIfNeeded();
        return super.read(b);
    }

    @Override
    public int available() throws IOException {
        this.skipIfNeeded();
        return super.available();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        this.skipIfNeeded();
        return super.skip(n);
    }

    private void skipIfNeeded() throws IOException {
        if (!this.skipped) {
            IOUtils.skipFully((InputStream)this.in, (long)this.skipBytes);
            this.skipped = true;
        }
    }

    public InputStream getWrapped() throws IOException {
        return this.in;
    }

    public long getSkippedBytes() {
        return this.skipBytes;
    }
}

