/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.store.ResultHeader;
import org.apache.james.mailbox.store.streaming.ByteContent;
import org.apache.james.mailbox.store.streaming.ConfigurableMimeTokenStream;
import org.apache.james.mailbox.store.streaming.FullByteContent;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.MimeEntityConfig;

public class PartContentBuilder {
    private static final byte[] EMPTY = new byte[0];
    private ConfigurableMimeTokenStream parser;
    private boolean empty = false;
    private boolean topLevel = true;

    public PartContentBuilder() {
        MimeEntityConfig config = new MimeEntityConfig();
        config.setMaxLineLen(-1);
        this.parser = new ConfigurableMimeTokenStream(config);
    }

    public void markEmpty() {
        this.empty = true;
    }

    public void parse(InputStream in) {
        this.parser.setRecursionMode(0);
        this.parser.parse(in);
        this.topLevel = true;
    }

    private void skipToStartOfInner(int position) throws IOException, MimeException {
        int state = this.parser.next();
        switch (state) {
            case 6: {
                break;
            }
            case 0: {
                break;
            }
            case -1: {
                throw new PartNotFoundException(position);
            }
            case 11: {
                throw new PartNotFoundException(position);
            }
            default: {
                this.skipToStartOfInner(position);
            }
        }
    }

    public void to(int position) throws IOException, MimeException {
        try {
            if (this.topLevel) {
                this.topLevel = false;
            } else {
                this.skipToStartOfInner(position);
            }
            int count = 0;
            while (count < position) {
                int state = this.parser.next();
                switch (state) {
                    case 12: {
                        if (position != 1) break;
                        ++count;
                        break;
                    }
                    case 10: {
                        ++count;
                        break;
                    }
                    case 6: {
                        if (count <= 0 || count >= position) break;
                        this.ignoreInnerMessage();
                        break;
                    }
                    case -1: {
                        throw new PartNotFoundException(position);
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            throw new PartNotFoundException(position, e);
        }
    }

    private void ignoreInnerMessage() throws IOException, UnexpectedEOFException, MimeException {
        int state = this.parser.next();
        while (state != 7) {
            switch (state) {
                case -1: {
                    throw new UnexpectedEOFException();
                }
                case 6: {
                    this.ignoreInnerMessage();
                }
            }
            state = this.parser.next();
        }
    }

    public Content getFullContent() throws IOException, UnexpectedEOFException, MimeException {
        List<MessageResult.Header> headers = this.getMimeHeaders();
        byte[] content = this.mimeBodyContent();
        return new FullByteContent(ByteBuffer.wrap(content), headers);
    }

    public Content getMessageBodyContent() throws IOException, MimeException {
        byte[] content = this.messageBodyContent();
        return new ByteContent(ByteBuffer.wrap(content));
    }

    private byte[] messageBodyContent() throws IOException, MimeException {
        byte[] content;
        if (this.empty) {
            content = EMPTY;
        } else {
            boolean valid;
            try {
                this.advancedToMessage();
                valid = true;
            }
            catch (UnexpectedEOFException e) {
                valid = false;
            }
            if (valid) {
                this.parser.setRecursionMode(3);
                int state = this.parser.getState();
                while (state != 12 && state != 6) {
                    if (state == -1) {
                        valid = false;
                        break;
                    }
                    state = this.parser.next();
                }
                content = valid ? IOUtils.toByteArray((InputStream)this.parser.getInputStream()) : EMPTY;
            } else {
                content = EMPTY;
            }
        }
        return content;
    }

    public Content getMimeBodyContent() throws IOException, MimeException {
        byte[] content = this.mimeBodyContent();
        return new ByteContent(ByteBuffer.wrap(content));
    }

    private byte[] mimeBodyContent() throws IOException, MimeException {
        byte[] content;
        if (this.empty) {
            content = EMPTY;
        } else {
            this.parser.setRecursionMode(3);
            boolean valid = true;
            int state = this.parser.getState();
            while (state != 12 && state != 6) {
                if (state == -1) {
                    valid = false;
                    break;
                }
                state = this.parser.next();
            }
            content = valid ? IOUtils.toByteArray((InputStream)this.parser.getInputStream()) : EMPTY;
        }
        return content;
    }

    public List<MessageResult.Header> getMimeHeaders() throws IOException, UnexpectedEOFException, MimeException {
        ArrayList<MessageResult.Header> results;
        if (this.empty) {
            results = Collections.EMPTY_LIST;
        } else {
            results = new ArrayList<MessageResult.Header>();
            int state = this.parser.getState();
            while (state != 5) {
                switch (state) {
                    case -1: {
                        throw new UnexpectedEOFException();
                    }
                    case 4: {
                        String fieldValue = this.parser.getField().getBody().trim();
                        String fieldName = this.parser.getField().getName();
                        ResultHeader header = new ResultHeader(fieldName, fieldValue);
                        results.add(header);
                    }
                }
                state = this.parser.next();
            }
        }
        return results;
    }

    public List<MessageResult.Header> getMessageHeaders() throws IOException, MimeException {
        ArrayList<MessageResult.Header> results;
        if (this.empty) {
            results = Collections.EMPTY_LIST;
        } else {
            results = new ArrayList<MessageResult.Header>();
            try {
                this.advancedToMessage();
                int state = this.parser.getState();
                while (state != 5) {
                    switch (state) {
                        case -1: {
                            throw new IOException("Unexpected EOF");
                        }
                        case 4: {
                            String fieldValue = this.parser.getField().getBody().trim();
                            String fieldName = this.parser.getField().getName();
                            ResultHeader header = new ResultHeader(fieldName, fieldValue);
                            results.add(header);
                        }
                    }
                    state = this.parser.next();
                }
            }
            catch (UnexpectedEOFException unexpectedEOFException) {
                // empty catch block
            }
        }
        return results;
    }

    private void advancedToMessage() throws IOException, UnexpectedEOFException, MimeException {
        int state = this.parser.getState();
        while (state != 0) {
            if (state == -1) {
                throw new UnexpectedEOFException();
            }
            state = this.parser.next();
        }
    }

    public static final class PartNotFoundException
    extends MimeException {
        private static final long serialVersionUID = 7519976990944851574L;
        private final int position;

        public PartNotFoundException(int position) {
            this(position, null);
        }

        public PartNotFoundException(int position, Exception e) {
            super("Part " + position + " not found.", (Throwable)e);
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static final class UnexpectedEOFException
    extends MimeException {
        private static final long serialVersionUID = -3755637466593055796L;

        public UnexpectedEOFException() {
            super("Unexpected EOF");
        }
    }
}

