/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.mail.MessagingException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.jsieve.mail.ActionKeep;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.jsieve.mail.ActionReject;
import org.apache.jsieve.mailet.ActionContext;
import org.apache.jsieve.mailet.FileIntoAction;
import org.apache.jsieve.mailet.KeepAction;
import org.apache.jsieve.mailet.MailAction;
import org.apache.jsieve.mailet.RedirectAction;
import org.apache.jsieve.mailet.RejectAction;
import org.apache.mailet.Mail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionDispatcher {
    private ConcurrentMap<Class, MailAction> fieldMailActionMap;

    public ActionDispatcher() throws MessagingException {
        this.setMethodMap(this.defaultMethodMap());
    }

    public void execute(Action anAction, Mail aMail, ActionContext context) throws MessagingException {
        MailAction mailAction = (MailAction)this.getMethodMap().get(anAction.getClass());
        mailAction.execute(anAction, aMail, context);
    }

    public ConcurrentMap<Class, MailAction> getMethodMap() {
        return this.fieldMailActionMap;
    }

    private ConcurrentMap<Class, MailAction> defaultMethodMap() {
        ConcurrentHashMap<Class, MailAction> actionMap = new ConcurrentHashMap<Class, MailAction>(4);
        actionMap.put(ActionFileInto.class, new FileIntoAction());
        actionMap.put(ActionKeep.class, new KeepAction());
        actionMap.put(ActionRedirect.class, new RedirectAction());
        actionMap.put(ActionReject.class, new RejectAction());
        return actionMap;
    }

    protected void setMethodMap(ConcurrentMap<Class, MailAction> mailActionMap) {
        this.fieldMailActionMap = mailActionMap;
    }
}

