/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import org.apache.commons.logging.Log;
import org.apache.mailet.base.GenericMailet;

class CommonsLoggingAdapter
implements Log {
    public static final int TRACE = 6;
    public static final int DEBUG = 5;
    public static final int INFO = 4;
    public static final int WARN = 3;
    public static final int ERROR = 2;
    public static final int FATAL = 1;
    private final GenericMailet mailet;
    private final int level;

    public CommonsLoggingAdapter(GenericMailet mailet, int level) {
        this.mailet = mailet;
        this.level = level;
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.level <= 5;
    }

    public boolean isErrorEnabled() {
        return this.level <= 2;
    }

    public boolean isFatalEnabled() {
        return this.level <= 1;
    }

    public boolean isInfoEnabled() {
        return this.level <= 4;
    }

    public boolean isTraceEnabled() {
        return this.level <= 6;
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.mailet.log(message == null ? "NULL" : message.toString(), t);
        }
    }
}

