/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mailet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionReject;
import org.apache.jsieve.mailet.ActionContext;
import org.apache.jsieve.mailet.ActionUtils;
import org.apache.jsieve.mailet.MailAction;
import org.apache.jsieve.mailet.mdn.ActionModeAutomatic;
import org.apache.jsieve.mailet.mdn.Disposition;
import org.apache.jsieve.mailet.mdn.DispositionModifier;
import org.apache.jsieve.mailet.mdn.MDNFactory;
import org.apache.jsieve.mailet.mdn.ModifierError;
import org.apache.jsieve.mailet.mdn.SendingModeAutomatic;
import org.apache.jsieve.mailet.mdn.TypeDeleted;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.mail.MimeMultipartReport;

public class RejectAction
implements MailAction {
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionReject) {
            ActionReject actionReject = (ActionReject)action;
            this.execute(actionReject, mail, context);
        }
    }

    public void execute(ActionReject anAction, Mail aMail, ActionContext context) throws MessagingException {
        ActionUtils.detectAndHandleLocalLooping(aMail, context, "reject");
        StringBuilder humanText = new StringBuilder(128);
        humanText.append("This message was refused by the recipient's mail filtering program.");
        humanText.append("\r\n");
        humanText.append("The reason given was:");
        humanText.append("\r\n");
        humanText.append("\r\n");
        humanText.append(anAction.getMessage());
        String reporting_UA_name = null;
        try {
            reporting_UA_name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            reporting_UA_name = "localhost";
        }
        String reporting_UA_product = context.getServerInfo();
        String[] originalRecipients = aMail.getMessage().getHeader("Original-Recipient");
        String original_recipient = null;
        if (null != originalRecipients && originalRecipients.length > 0) {
            original_recipient = originalRecipients[0];
        }
        MailAddress soleRecipient = ActionUtils.getSoleRecipient(aMail);
        String final_recipient = soleRecipient.toString();
        String original_message_id = aMail.getMessage().getMessageID();
        DispositionModifier[] modifiers = new DispositionModifier[]{new ModifierError()};
        Disposition disposition = new Disposition(new ActionModeAutomatic(), new SendingModeAutomatic(), new TypeDeleted(), modifiers);
        MimeMultipartReport multiPart = MDNFactory.create(humanText.toString(), reporting_UA_name, reporting_UA_product, original_recipient, final_recipient, original_message_id, disposition);
        MimeMessage reply = (MimeMessage)aMail.getMessage().reply(false);
        reply.setFrom((Address)soleRecipient.toInternetAddress());
        reply.setContent((Multipart)multiPart);
        reply.saveChanges();
        Address[] recipientAddresses = reply.getAllRecipients();
        if (null != recipientAddresses) {
            ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(recipientAddresses.length);
            for (int i = 0; i < recipientAddresses.length; ++i) {
                recipients.add(new MailAddress((InternetAddress)recipientAddresses[i]));
            }
            context.post(null, recipients, reply);
        } else {
            context.getLog().info((Object)"Unable to send reject MDN. Could not determine the recipient.");
        }
        aMail.setState("ghost");
    }
}

