/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.maildir.MaildirMessageName;

public class MaildirFolder {
    public static final String VALIDITY_FILE = "james-uidvalidity";
    public static final String UIDLIST_FILE = "james-uidlist";
    public static final String CUR = "cur";
    public static final String NEW = "new";
    public static final String TMP = "tmp";
    private File rootFolder;
    private File curFolder;
    private File newFolder;
    private File tmpFolder;
    private File uidFile;
    private long lastUid = -1L;
    private int messageCount = 0;
    private long uidValidity = -1L;
    private final MailboxPathLocker locker;
    private final MailboxPath path;

    public MaildirFolder(String absPath, MailboxPath path, MailboxPathLocker locker) {
        this.rootFolder = new File(absPath);
        this.curFolder = new File(this.rootFolder, CUR);
        this.newFolder = new File(this.rootFolder, NEW);
        this.tmpFolder = new File(this.rootFolder, TMP);
        this.uidFile = new File(this.rootFolder, UIDLIST_FILE);
        this.locker = locker;
        this.path = path;
    }

    public File getRootFile() {
        return this.rootFolder;
    }

    public boolean exists() {
        return this.rootFolder.isDirectory() && this.curFolder.isDirectory() && this.newFolder.isDirectory() && this.tmpFolder.isDirectory();
    }

    private boolean isModified() {
        long uidListModified = this.uidFile.lastModified();
        long curModified = this.curFolder.lastModified();
        long newModified = this.newFolder.lastModified();
        return curModified >= uidListModified || newModified >= uidListModified;
    }

    public File getCurFolder() {
        return this.curFolder;
    }

    public File getNewFolder() {
        return this.newFolder;
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }

    private long getNextUid() {
        return ++this.lastUid;
    }

    public long getLastUid(MailboxSession session) throws MailboxException {
        if (this.lastUid == -1L) {
            this.readLastUid(session);
        }
        return this.lastUid;
    }

    public long getHighestModSeq() throws IOException {
        long newModified = this.getNewFolder().lastModified();
        long curModified = this.getCurFolder().lastModified();
        if (newModified == 0L && curModified == 0L) {
            throw new IOException("Unable to read highest modSeq");
        }
        return Math.max(newModified, curModified);
    }

    private void readLastUid(MailboxSession session) throws MailboxException {
        this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            public Void execute() throws MailboxException {
                Void void_;
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                try {
                    String line;
                    if (!uidList.exists()) {
                        MaildirFolder.this.createUidFile();
                    }
                    if ((line = (reader = new BufferedReader(fileReader = new FileReader(uidList))).readLine()) != null) {
                        MaildirFolder.this.readUidListHeader(line);
                    }
                    void_ = null;
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to read last uid", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly(fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return void_;
            }
        });
    }

    public long getUidValidity() throws IOException {
        if (this.uidValidity == -1L) {
            this.uidValidity = this.readUidValidity();
        }
        return this.uidValidity;
    }

    public void setUidValidity(long uidValidity) throws IOException {
        this.saveUidValidity(uidValidity);
        this.uidValidity = uidValidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readUidValidity() throws IOException {
        long l;
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        if (!validityFile.exists()) {
            return this.resetUidValidity();
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(validityFile);
            isr = new InputStreamReader(fis);
            char[] uidValidity = new char[20];
            int len = isr.read(uidValidity);
            l = Long.parseLong(String.valueOf(uidValidity, 0, len).trim());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUidValidity(long uidValidity) throws IOException {
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        validityFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(validityFile);
        try {
            fos.write(String.valueOf(uidValidity).getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private long resetUidValidity() throws IOException {
        long timestamp = System.currentTimeMillis();
        this.setUidValidity(timestamp);
        return timestamp;
    }

    public MaildirMessageName getMessageNameByUid(MailboxSession session, final Long uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MaildirMessageName>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public MaildirMessageName execute() throws MailboxException {
                block7: {
                    fileReader = null;
                    reader = null;
                    uidList = MaildirFolder.access$000(MaildirFolder.this);
                    try {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        uidString = String.valueOf(uid);
                        line = reader.readLine();
                        lineNumber = 1;
                        while ((line = reader.readLine()) != null) {
                            if (line.equals("")) continue;
                            gap = line.indexOf(" ");
                            if (gap == -1) {
                                throw new MailboxException("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                            }
                            if (!line.substring(0, gap).equals(uidString)) continue;
                            var8_10 = new MaildirMessageName(MaildirFolder.this, line.substring(gap + 1));
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            throw new MailboxException("Unable to read messagename for uid " + uid, (Exception)e);
                        }
                        catch (Throwable var9_11) {
                            IOUtils.closeQuietly(reader);
                            IOUtils.closeQuietly((Reader)fileReader);
                            throw var9_11;
                        }
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return var8_10;
lbl-1000:
                // 1 sources

                {
                    var7_9 = null;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return var7_9;
            }
        });
    }

    public SortedMap<Long, MaildirMessageName> getUidMap(MailboxSession session, final long from, final long to) throws MailboxException {
        return (SortedMap)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<SortedMap<Long, MaildirMessageName>>(){

            public SortedMap<Long, MaildirMessageName> execute() throws MailboxException {
                TreeMap<Long, MaildirMessageName> uidMap = new TreeMap<Long, MaildirMessageName>();
                File uidList = MaildirFolder.this.uidFile;
                if (uidList.isFile()) {
                    if (MaildirFolder.this.isModified()) {
                        try {
                            uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.updateUidFile(), from, to));
                        }
                        catch (MailboxException e) {
                            uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.createUidFile(), from, to));
                        }
                    } else {
                        uidMap.putAll(MaildirFolder.this.readUidFile(from, to));
                    }
                } else {
                    uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.createUidFile(), from, to));
                }
                return uidMap;
            }
        });
    }

    public SortedMap<Long, MaildirMessageName> getUidMap(MailboxSession session, FilenameFilter filter, long from, long to) throws MailboxException {
        SortedMap<Long, MaildirMessageName> allUids = this.getUidMap(session, from, to);
        TreeMap<Long, MaildirMessageName> filteredUids = new TreeMap<Long, MaildirMessageName>();
        for (Map.Entry<Long, MaildirMessageName> entry : allUids.entrySet()) {
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
        }
        return filteredUids;
    }

    public SortedMap<Long, MaildirMessageName> getUidMap(MailboxSession session, FilenameFilter filter, int limit) throws MailboxException {
        SortedMap<Long, MaildirMessageName> allUids = this.getUidMap(session, 0L, -1L);
        TreeMap<Long, MaildirMessageName> filteredUids = new TreeMap<Long, MaildirMessageName>();
        int theLimit = limit;
        if (limit < 1) {
            theLimit = allUids.size();
        }
        int counter = 0;
        for (Map.Entry<Long, MaildirMessageName> entry : allUids.entrySet()) {
            if (counter >= theLimit) break;
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
            ++counter;
        }
        return filteredUids;
    }

    public SortedMap<Long, MaildirMessageName> getRecentMessages(MailboxSession session) throws MailboxException {
        final String[] recentFiles = this.getNewFolder().list();
        final LinkedList lines = new LinkedList();
        final int theLimit = recentFiles.length;
        return (SortedMap)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<SortedMap<Long, MaildirMessageName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public SortedMap<Long, MaildirMessageName> execute() throws MailboxException {
                TreeMap<Long, MaildirMessageName> recentMessages = new TreeMap<Long, MaildirMessageName>();
                File uidList = MaildirFolder.this.uidFile;
                try {
                    if (!uidList.isFile()) {
                        String[] allFiles;
                        uidList.createNewFile();
                        Object[] curFiles = MaildirFolder.this.curFolder.list();
                        Object[] newFiles = MaildirFolder.this.newFolder.list();
                        MaildirFolder.this.messageCount = curFiles.length + newFiles.length;
                        for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                            lines.add(String.valueOf(MaildirFolder.this.getNextUid()) + " " + file);
                        }
                        PrintWriter pw = new PrintWriter(uidList);
                        try {
                            pw.println(MaildirFolder.this.createUidListHeader());
                            for (String line : lines) {
                                pw.println(line);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Writer)pw);
                        }
                    }
                    FileReader fileReader = null;
                    BufferedReader reader = null;
                    try {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        String line = reader.readLine();
                        while ((line = reader.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    IOUtils.closeQuietly((Reader)fileReader);
                    int counter = 0;
                    block12: while (true) {
                        String line;
                        if (counter >= theLimit) return recentMessages;
                        try {
                            line = (String)lines.removeLast();
                        }
                        catch (NoSuchElementException e) {
                            return recentMessages;
                        }
                        if (line.equals("")) continue;
                        int gap = line.indexOf(" ");
                        if (gap == -1) {
                            throw new IOException("Corrupted entry in uid-file " + uidList + " line " + lines.size());
                        }
                        Long uid = Long.valueOf(line.substring(0, gap));
                        String name = line.substring(gap + 1, line.length());
                        String[] arr$ = recentFiles;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block12;
                            String recentFile = arr$[i$];
                            if (recentFile.equals(name)) {
                                recentMessages.put(uid, new MaildirMessageName(MaildirFolder.this, recentFile));
                                ++counter;
                                continue block12;
                            }
                            ++i$;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to read recent messages", (Exception)e);
                }
            }
        });
    }

    private Map<Long, MaildirMessageName> createUidFile() throws MailboxException {
        TreeMap<Long, MaildirMessageName> uidMap = new TreeMap<Long, MaildirMessageName>();
        File uidList = this.uidFile;
        PrintWriter pw = null;
        try {
            String[] allFiles;
            uidList.createNewFile();
            this.lastUid = 0L;
            Object[] curFiles = this.curFolder.list();
            Object[] newFiles = this.newFolder.list();
            this.messageCount = curFiles.length + newFiles.length;
            for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                uidMap.put(this.getNextUid(), new MaildirMessageName(this, file));
            }
            pw = new PrintWriter(uidList);
            pw.println(this.createUidListHeader());
            for (Map.Entry entry : uidMap.entrySet()) {
                pw.println(String.valueOf(entry.getKey()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to create uid file", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        return uidMap;
    }

    private Map<Long, MaildirMessageName> updateUidFile() throws MailboxException {
        TreeMap<Long, MaildirMessageName> uidMap = new TreeMap<Long, MaildirMessageName>();
        File uidList = this.uidFile;
        Object[] curFiles = this.curFolder.list();
        Object[] newFiles = this.newFolder.list();
        this.messageCount = curFiles.length + newFiles.length;
        HashMap<String, Long> reverseUidMap = new HashMap<String, Long>(this.messageCount);
        FileReader fileReader = null;
        BufferedReader reader = null;
        PrintWriter pw = null;
        try {
            String[] allFiles;
            fileReader = new FileReader(uidList);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    throw new MailboxException("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                }
                Long uid = Long.valueOf(line.substring(0, gap));
                String name = line.substring(gap + 1, line.length());
                reverseUidMap.put(MaildirFolder.stripMetaFromName(name), uid);
            }
            for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                MaildirMessageName messageName = new MaildirMessageName(this, file);
                Long uid = (Long)reverseUidMap.get(messageName.getBaseName());
                if (uid == null) {
                    uid = this.getNextUid();
                }
                uidMap.put(uid, messageName);
            }
            pw = new PrintWriter(uidList);
            pw.println(this.createUidListHeader());
            for (Map.Entry entry : uidMap.entrySet()) {
                pw.println(String.valueOf(entry.getKey()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to update uid file", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pw);
                IOUtils.closeQuietly((Reader)fileReader);
                IOUtils.closeQuietly((Reader)fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)fileReader);
        return uidMap;
    }

    private Map<Long, MaildirMessageName> readUidFile(long from, long to) throws MailboxException {
        HashMap<Long, MaildirMessageName> uidMap = new HashMap<Long, MaildirMessageName>();
        File uidList = this.uidFile;
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(uidList);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    throw new MailboxException("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                }
                Long uid = Long.valueOf(line.substring(0, gap));
                if (uid < from) continue;
                if (to != -1L && uid > to) break;
                String name = line.substring(gap + 1, line.length());
                uidMap.put(uid, new MaildirMessageName(this, name));
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to read uid file", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((Reader)fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)fileReader);
        this.messageCount = uidMap.size();
        return uidMap;
    }

    private SortedMap<Long, MaildirMessageName> truncateMap(Map<Long, MaildirMessageName> source, long from, long to) {
        TreeMap<Long, MaildirMessageName> sortedMap = source instanceof TreeMap ? (TreeMap<Long, MaildirMessageName>)source : new TreeMap<Long, MaildirMessageName>(source);
        if (to != -1L) {
            return sortedMap.subMap(from, to + 1L);
        }
        return sortedMap.tailMap(from);
    }

    private void readUidListHeader(String line) throws IOException {
        int gap1 = line.indexOf(" ");
        if (gap1 == -1) {
            throw new IOException("Corrupted header entry in uid-file");
        }
        int version = Integer.valueOf(line.substring(0, gap1));
        if (version != 1) {
            throw new IOException("Cannot read uidlists with versions other than 1.");
        }
        int gap2 = line.indexOf(" ", gap1 + 1);
        this.lastUid = Long.valueOf(line.substring(gap1 + 1, gap2));
        this.messageCount = Integer.valueOf(line.substring(gap2 + 1, line.length()));
    }

    private String createUidListHeader() {
        return "1 " + String.valueOf(this.lastUid) + " " + String.valueOf(this.messageCount);
    }

    public static String stripMetaFromName(String fileName) {
        int end = fileName.indexOf(",S=");
        if (end == -1) {
            end = fileName.indexOf(":2,");
        }
        if (end == -1) {
            return fileName;
        }
        return fileName.substring(0, end);
    }

    public long appendMessage(MailboxSession session, final String name) throws MailboxException {
        return (Long)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Long>(){

            public Long execute() throws MailboxException {
                File uidList = MaildirFolder.this.uidFile;
                long uid = -1L;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter pw = null;
                try {
                    if (uidList.isFile()) {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        String line = reader.readLine();
                        if (line != null) {
                            MaildirFolder.this.readUidListHeader(line);
                        }
                        ArrayList<String> lines = new ArrayList<String>(MaildirFolder.this.messageCount);
                        while ((line = reader.readLine()) != null) {
                            lines.add(line);
                        }
                        uid = MaildirFolder.this.getNextUid();
                        lines.add(String.valueOf(uid) + " " + name);
                        MaildirFolder.this.messageCount++;
                        pw = new PrintWriter(uidList);
                        pw.println(MaildirFolder.this.createUidListHeader());
                        for (String entry : lines) {
                            pw.println(entry);
                        }
                    } else {
                        String[] allFiles;
                        uidList.createNewFile();
                        Object[] curFiles = MaildirFolder.this.curFolder.list();
                        Object[] newFiles = MaildirFolder.this.newFolder.list();
                        MaildirFolder.this.messageCount = curFiles.length + newFiles.length;
                        ArrayList<String> lines = new ArrayList<String>(MaildirFolder.this.messageCount);
                        for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                            long theUid = MaildirFolder.this.getNextUid();
                            lines.add(String.valueOf(theUid) + " " + file);
                            if (!file.equals(name)) continue;
                            uid = theUid;
                        }
                        pw = new PrintWriter(uidList);
                        pw.println(MaildirFolder.this.createUidListHeader());
                        for (String line : lines) {
                            pw.println(line);
                        }
                    }
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to append msg", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(pw);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)pw);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                if (uid == -1L) {
                    throw new MailboxException("Unable to append msg");
                }
                return uid;
            }
        });
    }

    public void update(MailboxSession session, final long uid, final String messageName) throws MailboxException {
        this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            public Void execute() throws MailboxException {
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter writer = null;
                try {
                    fileReader = new FileReader(uidList);
                    reader = new BufferedReader(fileReader);
                    String line = reader.readLine();
                    MaildirFolder.this.readUidListHeader(line);
                    ArrayList<String> lines = new ArrayList<String>(MaildirFolder.this.messageCount);
                    while ((line = reader.readLine()) != null) {
                        if (uid == Long.valueOf(line.substring(0, line.indexOf(" ")))) {
                            line = String.valueOf(uid) + " " + messageName;
                        }
                        lines.add(line);
                    }
                    writer = new PrintWriter(uidList);
                    writer.println(MaildirFolder.this.createUidListHeader());
                    for (String entry : lines) {
                        writer.println(entry);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to update msg with uid " + uid, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)writer);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return null;
            }
        });
    }

    public MaildirMessageName delete(MailboxSession session, final long uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MaildirMessageName>(){

            public MaildirMessageName execute() throws MailboxException {
                MaildirMessageName maildirMessageName;
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter writer = null;
                MaildirMessageName deletedMessage = null;
                try {
                    String line;
                    fileReader = new FileReader(uidList);
                    reader = new BufferedReader(fileReader);
                    MaildirFolder.this.readUidListHeader(reader.readLine());
                    ArrayList<String> lines = new ArrayList<String>(MaildirFolder.this.messageCount - 1);
                    int lineNumber = 1;
                    while ((line = reader.readLine()) != null) {
                        int gap = line.indexOf(" ");
                        if (gap == -1) {
                            throw new IOException("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                        }
                        if (uid == Long.valueOf(line.substring(0, line.indexOf(" ")))) {
                            deletedMessage = new MaildirMessageName(MaildirFolder.this, line.substring(gap + 1, line.length()));
                            MaildirFolder.this.messageCount--;
                            continue;
                        }
                        lines.add(line);
                    }
                    if (deletedMessage != null) {
                        if (!deletedMessage.getFile().delete()) {
                            throw new IOException("Cannot delete file " + deletedMessage.getFile().getAbsolutePath());
                        }
                        writer = new PrintWriter(uidList);
                        writer.println(MaildirFolder.this.createUidListHeader());
                        for (String entry : lines) {
                            writer.println(entry);
                        }
                    }
                    maildirMessageName = deletedMessage;
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to delete msg with uid " + uid, (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return maildirMessageName;
            }
        });
    }

    public String toString() {
        return this.getRootFile().getAbsolutePath();
    }
}

