/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import org.apache.james.mailbox.maildir.MaildirFolder;

public class MaildirMessageName {
    public static final String FLAG_DRAFT = "D";
    public static final String FLAG_FLAGGED = "F";
    public static final String FLAG_ANSWERD = "R";
    public static final String FLAG_SEEN = "S";
    public static final String FLAG_DELETED = "T";
    public static final String PATTERN_STRING_MESSAGE_NAME = "\\d+\\.\\w+\\..+?";
    public static final String PATTERN_STRING_FLAGS = ":2,[DFRST]*";
    public static final String PATTERN_STRING_SIZE = ",S=\\d+";
    public static final Pattern PATTERN_MESSAGE = Pattern.compile("\\d+\\.\\w+\\..+?" + MaildirMessageName.optional(",S=\\d+") + MaildirMessageName.optional(":2,[DFRST]*"));
    public static final Pattern PATTERN_UNSEEN_MESSAGES = Pattern.compile("\\d+\\.\\w+\\..+?,S=\\d+" + MaildirMessageName.optional(":2,[^S]*"));
    public static final FilenameFilter FILTER_UNSEEN_MESSAGES = MaildirMessageName.createRegexFilter(PATTERN_UNSEEN_MESSAGES);
    public static final Pattern PATTERN_DELETED_MESSAGES = Pattern.compile("\\d+\\.\\w+\\..+?,S=\\d+:2,.*T");
    public static final FilenameFilter FILTER_DELETED_MESSAGES = MaildirMessageName.createRegexFilter(PATTERN_DELETED_MESSAGES);
    private static AtomicInteger deliveries = new AtomicInteger(0);
    private static Random random = new Random();
    private static String processName = ManagementFactory.getRuntimeMXBean().getName();
    private static String currentHostname;
    private String fullName;
    private File file;
    private MaildirFolder parentFolder;
    private String timestamp;
    private String uniqueString;
    private String hostnameAndMeta;
    private String hostname;
    private String sizeString;
    private String flagsString;
    private boolean isSplit;
    private Date internalDate;
    private Long size;
    private Flags flags;

    public MaildirMessageName(MaildirFolder parentFolder, String fullName) {
        this.parentFolder = parentFolder;
        this.setFullName(fullName);
    }

    public boolean exists() {
        if (this.file != null && this.file.isFile()) {
            return true;
        }
        File assumedFile1 = new File(this.parentFolder.getCurFolder(), this.fullName);
        if (assumedFile1.isFile()) {
            this.file = assumedFile1;
            return true;
        }
        File assumedFile2 = new File(this.parentFolder.getNewFolder(), this.fullName);
        if (assumedFile2.isFile()) {
            this.file = assumedFile2;
            return true;
        }
        FilenameFilter filter = this.getFilenameFilter();
        File[] matchingFiles1 = this.parentFolder.getCurFolder().listFiles(filter);
        if (matchingFiles1.length == 1) {
            this.setFullName(matchingFiles1[0].getName());
            this.file = matchingFiles1[0];
            return true;
        }
        File[] matchingFiles2 = this.parentFolder.getNewFolder().listFiles(filter);
        if (matchingFiles2.length == 1) {
            this.setFullName(matchingFiles2[0].getName());
            this.file = matchingFiles2[0];
            return true;
        }
        return false;
    }

    public void setFullName(String fullName) {
        if (this.fullName == null || !this.fullName.equals(fullName)) {
            this.fullName = fullName;
            this.file = null;
            this.isSplit = false;
            this.internalDate = null;
            this.size = null;
            this.flags = null;
        }
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuffer fullBuffer = new StringBuffer();
            fullBuffer.append(this.timestamp);
            fullBuffer.append(".");
            fullBuffer.append(this.uniqueString);
            fullBuffer.append(".");
            fullBuffer.append(this.hostname);
            if (this.sizeString != null) {
                fullBuffer.append(this.sizeString);
            }
            if (this.flagsString != null) {
                fullBuffer.append(this.flagsString);
            }
            this.fullName = fullBuffer.toString();
        }
        return this.fullName;
    }

    public File getFile() throws FileNotFoundException {
        if (this.exists()) {
            return this.file;
        }
        throw new FileNotFoundException("There is no file for message name " + this.fullName + " in mailbox " + this.parentFolder.getRootFile().getAbsolutePath());
    }

    public FilenameFilter getFilenameFilter() {
        this.split();
        StringBuffer pattern = new StringBuffer();
        pattern.append(this.timestamp);
        pattern.append("\\.");
        pattern.append(this.uniqueString);
        pattern.append("\\.");
        pattern.append(this.hostname);
        pattern.append(".*");
        return MaildirMessageName.createRegexFilter(Pattern.compile(pattern.toString()));
    }

    private void split() {
        if (!this.isSplit) {
            this.splitFullName();
            this.splitHostNameAndMeta();
            this.isSplit = true;
        }
    }

    private void splitFullName() {
        int firstEnd = this.fullName.indexOf(46);
        int secondEnd = this.fullName.indexOf(46, firstEnd + 1);
        this.timestamp = this.fullName.substring(0, firstEnd);
        this.uniqueString = this.fullName.substring(firstEnd + 1, secondEnd);
        this.hostnameAndMeta = this.fullName.substring(secondEnd + 1, this.fullName.length());
    }

    private void splitHostNameAndMeta() {
        int firstEnd = this.hostnameAndMeta.indexOf(44);
        int secondEnd = this.hostnameAndMeta.indexOf(58, firstEnd + 1);
        this.hostname = this.hostnameAndMeta.substring(0, firstEnd);
        if (secondEnd != -1) {
            this.sizeString = this.hostnameAndMeta.substring(firstEnd, secondEnd);
            this.flagsString = this.hostnameAndMeta.substring(secondEnd, this.hostnameAndMeta.length());
        } else {
            this.sizeString = this.hostnameAndMeta.substring(firstEnd, this.hostnameAndMeta.length());
        }
    }

    public void setFlags(Flags flags) {
        if (this.flags != flags) {
            this.split();
            this.flags = flags;
            this.flagsString = this.encodeFlags(flags);
            this.fullName = null;
        }
    }

    public Flags getFlags() {
        if (this.flags == null) {
            this.split();
            if (this.flagsString == null) {
                return null;
            }
            this.flags = this.decodeFlags(this.flagsString.substring(3));
        }
        return this.flags;
    }

    public Long getSize() {
        if (this.size == null) {
            this.split();
            if (this.sizeString == null) {
                return null;
            }
            this.size = Long.valueOf(this.sizeString.substring(3));
        }
        return this.size;
    }

    public Date getInternalDate() {
        if (this.internalDate == null) {
            this.split();
            if (this.timestamp == null) {
                return null;
            }
            this.internalDate = new Date(Long.valueOf(this.timestamp) * 1000L);
        }
        return this.internalDate;
    }

    public String getBaseName() {
        this.split();
        StringBuffer baseName = new StringBuffer();
        baseName.append(this.timestamp);
        baseName.append(".");
        baseName.append(this.uniqueString);
        baseName.append(".");
        baseName.append(this.hostname);
        return baseName.toString();
    }

    public String encodeFlags(Flags flags) {
        StringBuffer flagsString = new StringBuffer(":2,");
        if (flags.contains(Flags.Flag.DRAFT)) {
            flagsString.append(FLAG_DRAFT);
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            flagsString.append(FLAG_FLAGGED);
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            flagsString.append(FLAG_ANSWERD);
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            flagsString.append(FLAG_SEEN);
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            flagsString.append(FLAG_DELETED);
        }
        return flagsString.toString();
    }

    public Flags decodeFlags(String flagsString) {
        Flags flags = new Flags();
        if (flagsString.contains(FLAG_DRAFT)) {
            flags.add(Flags.Flag.DRAFT);
        }
        if (flagsString.contains(FLAG_FLAGGED)) {
            flags.add(Flags.Flag.FLAGGED);
        }
        if (flagsString.contains(FLAG_ANSWERD)) {
            flags.add(Flags.Flag.ANSWERED);
        }
        if (flagsString.contains(FLAG_SEEN)) {
            flags.add(Flags.Flag.SEEN);
        }
        if (flagsString.contains(FLAG_DELETED)) {
            flags.add(Flags.Flag.DELETED);
        }
        return flags;
    }

    private static long getNextDeliveryNumber() {
        return deliveries.getAndIncrement();
    }

    public static MaildirMessageName createUniqueName(MaildirFolder parentFolder, long size) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        timestamp = timestamp.substring(0, timestamp.length() - 3);
        StringBuffer uniquePart = new StringBuffer();
        uniquePart.append(Integer.toHexString(random.nextInt()));
        uniquePart.append(timestamp.substring(timestamp.length() - 3));
        uniquePart.append(processName);
        uniquePart.append(MaildirMessageName.getNextDeliveryNumber());
        String sizeString = ",S=" + String.valueOf(size);
        String fullName = timestamp + "." + uniquePart.toString() + "." + currentHostname + sizeString;
        MaildirMessageName uniqueName = new MaildirMessageName(parentFolder, fullName);
        uniqueName.timestamp = timestamp;
        uniqueName.uniqueString = uniquePart.toString();
        uniqueName.hostname = currentHostname;
        uniqueName.sizeString = sizeString;
        uniqueName.isSplit = true;
        uniqueName.size = size;
        return uniqueName;
    }

    public static FilenameFilter createRegexFilter(final Pattern pattern) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = pattern.matcher(name);
                return matcher.matches();
            }
        };
    }

    public static String optional(String pattern) {
        return "(" + pattern + ")?";
    }

    public String toString() {
        return this.getFullName();
    }

    static {
        String[] parts = processName.split("@");
        if (parts.length > 1) {
            processName = parts[0];
        }
        try {
            currentHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            currentHostname = "localhost";
        }
    }
}

