/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;

public class MaildirMailboxMapper
extends NonTransactionalMapper
implements MailboxMapper<Integer> {
    private final MaildirStore maildirStore;
    private ArrayList<Mailbox<Integer>> mailboxCache = new ArrayList();
    private final MailboxSession session;

    public MaildirMailboxMapper(MaildirStore maildirStore, MailboxSession session) {
        this.maildirStore = maildirStore;
        this.session = session;
    }

    public void delete(Mailbox<Integer> mailbox) throws MailboxException {
        String folderName = this.maildirStore.getFolderName(mailbox);
        File folder = new File(folderName);
        if (folder.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException e) {
                throw new MailboxException("Unable to delete Mailbox " + mailbox, (Exception)e);
            }
        } else {
            throw new MailboxNotFoundException(mailbox.getName());
        }
    }

    public Mailbox<Integer> findMailboxByPath(MailboxPath mailboxPath) throws MailboxException, MailboxNotFoundException {
        Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, mailboxPath);
        return this.cacheMailbox(mailbox);
    }

    public List<Mailbox<Integer>> findMailboxWithPathLike(MailboxPath mailboxPath) throws MailboxException {
        Pattern searchPattern = Pattern.compile("[.]" + mailboxPath.getName().replace(".", "\\.").replace("%", ".*"));
        FilenameFilter filter = MaildirMessageName.createRegexFilter(searchPattern);
        File root = this.maildirStore.getMailboxRootForUser(mailboxPath.getUser());
        File[] folders = root.listFiles(filter);
        ArrayList<Mailbox<Integer>> mailboxList = new ArrayList<Mailbox<Integer>>();
        for (File folder : folders) {
            if (!folder.isDirectory()) continue;
            Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, root, mailboxPath.getNamespace(), mailboxPath.getUser(), folder.getName());
            mailboxList.add(this.cacheMailbox(mailbox));
        }
        if (Pattern.matches(mailboxPath.getName().replace("%", ".*"), "INBOX")) {
            Mailbox<Integer> mailbox = this.maildirStore.loadMailbox(this.session, root, mailboxPath.getNamespace(), mailboxPath.getUser(), "");
            mailboxList.add(0, this.cacheMailbox(mailbox));
        }
        return mailboxList;
    }

    public boolean hasChildren(Mailbox<Integer> mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        String searchString = mailbox.getName() + "." + "%";
        List<Mailbox<Integer>> mailboxes = this.findMailboxWithPathLike(new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), searchString));
        return mailboxes.size() > 0;
    }

    public void save(Mailbox<Integer> mailbox) throws MailboxException {
        try {
            Mailbox<Integer> originalMailbox = this.getCachedMailbox((Integer)mailbox.getMailboxId());
            MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
            if (originalMailbox.getName() != mailbox.getName()) {
                if (folder.exists()) {
                    throw new MailboxExistsException(mailbox.getName());
                }
                MaildirFolder originalFolder = this.maildirStore.createMaildirFolder(originalMailbox);
                if (originalMailbox.getName().equals("INBOX")) {
                    File inboxFolder = originalFolder.getRootFile();
                    File newFolder = folder.getRootFile();
                    if (!newFolder.mkdirs()) {
                        throw new MailboxException("Failed to saveMailbox " + mailbox);
                    }
                    originalFolder.getCurFolder().renameTo(folder.getCurFolder());
                    originalFolder.getNewFolder().renameTo(folder.getNewFolder());
                    originalFolder.getTmpFolder().renameTo(folder.getTmpFolder());
                    new File(inboxFolder, "james-uidlist").renameTo(new File(newFolder, "james-uidlist"));
                    new File(inboxFolder, "james-uidvalidity").renameTo(new File(newFolder, "james-uidvalidity"));
                    originalFolder.getCurFolder().mkdir();
                    originalFolder.getNewFolder().mkdir();
                    originalFolder.getTmpFolder().mkdir();
                } else if (!originalFolder.getRootFile().renameTo(folder.getRootFile())) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)new IOException("Could not rename folder " + originalFolder));
                }
            }
        }
        catch (MailboxNotFoundException e) {
            MaildirFolder folder = this.maildirStore.createMaildirFolder(mailbox);
            if (!folder.exists()) {
                boolean success = folder.getRootFile().exists();
                if (!success) {
                    success = folder.getRootFile().mkdirs();
                }
                if (!success) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox);
                }
                success = folder.getCurFolder().mkdir();
                success = success && folder.getNewFolder().mkdir();
                boolean bl = success = success && folder.getTmpFolder().mkdir();
                if (!success) {
                    throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)new IOException("Needed folder structure can not be created"));
                }
            }
            try {
                folder.setUidValidity(mailbox.getUidValidity());
            }
            catch (IOException ioe) {
                throw new MailboxException("Failed to save Mailbox " + mailbox, (Exception)ioe);
            }
        }
    }

    public List<Mailbox<Integer>> list() throws MailboxException {
        File[] domains;
        File maildirRoot = this.maildirStore.getMaildirRoot();
        ArrayList<Mailbox<Integer>> mailboxList = new ArrayList<Mailbox<Integer>>();
        if (this.maildirStore.getMaildirLocation().endsWith("/%fulluser")) {
            File[] users = maildirRoot.listFiles();
            this.visitUsersForMailboxList(null, users, mailboxList);
            return mailboxList;
        }
        for (File domain : domains = maildirRoot.listFiles()) {
            File[] users = domain.listFiles();
            this.visitUsersForMailboxList(domain, users, mailboxList);
        }
        return mailboxList;
    }

    public void endRequest() {
        this.mailboxCache.clear();
    }

    private Mailbox<Integer> cacheMailbox(Mailbox<Integer> mailbox) {
        this.mailboxCache.add((Mailbox<Integer>)new SimpleMailbox(mailbox));
        int id = this.mailboxCache.size() - 1;
        ((SimpleMailbox)mailbox).setMailboxId((Object)id);
        return mailbox;
    }

    private Mailbox<Integer> getCachedMailbox(Integer mailboxId) throws MailboxNotFoundException {
        if (mailboxId == null) {
            throw new MailboxNotFoundException("null");
        }
        try {
            return this.mailboxCache.get(mailboxId);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MailboxNotFoundException(String.valueOf(mailboxId));
        }
    }

    private void visitUsersForMailboxList(File domain, File[] users, List<Mailbox<Integer>> mailboxList) throws MailboxException {
        String userName = null;
        for (File user : users) {
            File[] mailboxes;
            userName = domain == null ? user.getName() : user.getName() + "@" + domain.getName();
            MailboxPath inboxMailboxPath = new MailboxPath(this.session.getPersonalSpace(), userName, "INBOX");
            mailboxList.add(this.maildirStore.loadMailbox(this.session, inboxMailboxPath));
            for (File mailbox : mailboxes = user.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(".");
                }
            })) {
                MailboxPath mailboxPath = new MailboxPath("#private", userName, mailbox.getName().substring(1));
                mailboxList.add(this.maildirStore.loadMailbox(this.session, mailboxPath));
            }
        }
    }
}

