/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.store.mail.model.AbstractMessage;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.streaming.ConfigurableMimeTokenStream;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mailbox.store.streaming.LazySkippingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.MaximalBodyDescriptor;
import org.apache.james.mime4j.parser.MimeEntityConfig;

public class MaildirMessage
extends AbstractMessage<Integer> {
    private MaildirMessageName messageName;
    private int bodyStartOctet;
    private final PropertyBuilder propertyBuilder = new PropertyBuilder();
    private boolean parsed;
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private Mailbox<Integer> mailbox;
    private long uid;
    protected boolean newMessage;
    private long modSeq;

    public MaildirMessage(Mailbox<Integer> mailbox, long uid, MaildirMessageName messageName) throws IOException {
        this.mailbox = mailbox;
        this.setUid(uid);
        this.setModSeq(messageName.getFile().lastModified());
        Flags flags = messageName.getFlags();
        File file = messageName.getFile();
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to read file " + file.getAbsolutePath() + " for the message");
        }
        if (file.getParentFile().getName().equals("new")) {
            flags.add(Flags.Flag.RECENT);
        }
        this.setFlags(flags);
        this.messageName = messageName;
    }

    public Integer getMailboxId() {
        return (Integer)this.mailbox.getMailboxId();
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setFlags(Flags flags) {
        if (flags != null) {
            this.answered = flags.contains(Flags.Flag.ANSWERED);
            this.deleted = flags.contains(Flags.Flag.DELETED);
            this.draft = flags.contains(Flags.Flag.DRAFT);
            this.flagged = flags.contains(Flags.Flag.FLAGGED);
            this.recent = flags.contains(Flags.Flag.RECENT);
            this.seen = flags.contains(Flags.Flag.SEEN);
        }
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public boolean isRecent() {
        return this.recent;
    }

    public boolean isSeen() {
        return this.seen;
    }

    public void unsetRecent() {
        this.recent = false;
    }

    public boolean isNew() {
        return this.newMessage;
    }

    public String toString() {
        StringBuffer theString = new StringBuffer("MaildirMessage ");
        theString.append(this.getUid());
        theString.append(" {");
        Flags flags = this.createFlags();
        if (flags.contains(Flags.Flag.DRAFT)) {
            theString.append("D");
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            theString.append("F");
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            theString.append("R");
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            theString.append("S");
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            theString.append("T");
        }
        theString.append("} ");
        theString.append(this.getInternalDate());
        return theString.toString();
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parseMessage() {
        block31: {
            if (this.parsed) {
                return;
            }
            SharedFileInputStream tmpMsgIn = null;
            try {
                String boundary;
                String subType;
                String mediaType;
                tmpMsgIn = new SharedFileInputStream(this.messageName.getFile());
                this.bodyStartOctet = this.bodyStartOctet((InputStream)tmpMsgIn);
                MimeEntityConfig config = new MimeEntityConfig();
                config.setMaximalBodyDescriptor(true);
                config.setMaxLineLen(-1);
                ConfigurableMimeTokenStream parser = new ConfigurableMimeTokenStream(config);
                parser.setRecursionMode(1);
                parser.parse(tmpMsgIn.newStream(0L, -1L));
                int next = parser.next();
                while (next != 12 && next != -1 && next != 6) {
                    next = parser.next();
                }
                MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
                String mediaTypeFromHeader = descriptor.getMediaType();
                if (mediaTypeFromHeader == null) {
                    mediaType = "text";
                    subType = "plain";
                } else {
                    mediaType = mediaTypeFromHeader;
                    subType = descriptor.getSubType();
                }
                this.propertyBuilder.setMediaType(mediaType);
                this.propertyBuilder.setSubType(subType);
                this.propertyBuilder.setContentID(descriptor.getContentId());
                this.propertyBuilder.setContentDescription(descriptor.getContentDescription());
                this.propertyBuilder.setContentLocation(descriptor.getContentLocation());
                this.propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
                this.propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
                this.propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
                this.propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
                this.propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
                this.propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
                String codeset = descriptor.getCharset();
                if (codeset == null) {
                    if ("TEXT".equalsIgnoreCase(mediaType)) {
                        this.propertyBuilder.setCharset("us-ascii");
                    }
                } else {
                    this.propertyBuilder.setCharset(codeset);
                }
                if ((boundary = descriptor.getBoundary()) != null) {
                    this.propertyBuilder.setBoundary(boundary);
                }
                if (!"text".equalsIgnoreCase(mediaType)) break block31;
                long lines = -1L;
                CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
                try {
                    bodyStream.readAll();
                    lines = bodyStream.getLineCount();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)bodyStream);
                }
                next = parser.next();
                if (next == 9) {
                    CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                    try {
                        epilogueStream.readAll();
                        lines += (long)epilogueStream.getLineCount();
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)epilogueStream);
                    }
                }
                this.propertyBuilder.setTextualLineCount(Long.valueOf(lines));
            }
            catch (IOException e) {
            }
            catch (MimeException e) {
            }
            finally {
                if (tmpMsgIn != null) {
                    try {
                        tmpMsgIn.close();
                    }
                    catch (IOException e) {}
                }
                this.parsed = true;
            }
        }
    }

    private int bodyStartOctet(InputStream msgIn) throws IOException {
        PushbackInputStream in = new PushbackInputStream(msgIn, 3);
        int bodyStartOctet = in.available();
        int i = -1;
        int count = 0;
        while ((i = in.read()) != -1 && in.available() > 4) {
            if (i == 13) {
                int a = in.read();
                if (a == 10) {
                    int b = in.read();
                    if (b == 13) {
                        int c = in.read();
                        if (c == 10) {
                            bodyStartOctet = count + 4;
                            break;
                        }
                        in.unread(c);
                    }
                    in.unread(b);
                }
                in.unread(a);
            }
            ++count;
        }
        return bodyStartOctet;
    }

    public String getMediaType() {
        this.parseMessage();
        return this.propertyBuilder.getMediaType();
    }

    public String getSubType() {
        this.parseMessage();
        return this.propertyBuilder.getSubType();
    }

    public long getFullContentOctets() {
        return this.messageName.getSize();
    }

    public Long getTextualLineCount() {
        this.parseMessage();
        return this.propertyBuilder.getTextualLineCount();
    }

    public List<Property> getProperties() {
        this.parseMessage();
        return this.propertyBuilder.toProperties();
    }

    public Date getInternalDate() {
        return this.messageName.getInternalDate();
    }

    private InputStream getFullContent() throws IOException {
        return new FileInputStream(this.messageName.getFile());
    }

    public InputStream getBodyContent() throws IOException {
        this.parseMessage();
        return new LazySkippingInputStream(this.getFullContent(), (long)this.bodyStartOctet);
    }

    protected int getBodyStartOctet() {
        this.parseMessage();
        return this.bodyStartOctet;
    }

    public InputStream getHeaderContent() throws IOException {
        this.parseMessage();
        long limit = this.getBodyStartOctet() - 2;
        if (limit < 0L) {
            limit = 0L;
        }
        return new BoundedInputStream(this.getFullContent(), limit);
    }
}

