/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.james.queue.api.MailQueue;
import org.apache.mailet.Mail;

public class JMSMailQueueItem
implements MailQueue.MailQueueItem {
    protected final Mail mail;
    protected final Connection connection;
    protected final Session session;
    protected final MessageConsumer consumer;

    public JMSMailQueueItem(Mail mail, Connection connection, Session session, MessageConsumer consumer) {
        this.mail = mail;
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
    }

    public void done(boolean success) throws MailQueue.MailQueueException {
        try {
            if (success) {
                this.session.commit();
            } else {
                try {
                    this.session.rollback();
                }
                catch (JMSException e1) {
                    // empty catch block
                }
            }
        }
        catch (JMSException ex) {
            throw new MailQueue.MailQueueException("Unable to commit dequeue operation for mail " + this.mail.getName(), (Exception)((Object)ex));
        }
        finally {
            if (this.consumer != null) {
                try {
                    this.consumer.close();
                }
                catch (JMSException e1) {}
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException e) {}
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public Mail getMail() {
        return this.mail;
    }
}

