/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueManagementMBean;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.library.MailQueueManagement;
import org.slf4j.Logger;

public abstract class AbstractMailQueueFactory
implements MailQueueFactory,
LogEnabled {
    protected final Map<String, MailQueue> queues = new HashMap<String, MailQueue>();
    protected Logger log;
    private boolean useJMX = true;
    private MBeanServer mbeanServer;
    private List<String> mbeans = new ArrayList<String>();

    public void setUseJMX(boolean useJMX) {
        this.useJMX = useJMX;
    }

    @PostConstruct
    public void init() {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @PreDestroy
    public void destroy() {
        for (int i = 0; i < this.mbeans.size(); ++i) {
            this.unregisterMBean(this.mbeans.get(i));
        }
        Iterator<MailQueue> it = this.queues.values().iterator();
        while (it.hasNext()) {
            LifecycleUtil.dispose((Object)it.next());
        }
    }

    public final synchronized MailQueue getQueue(String name) {
        MailQueue queue = this.queues.get(name);
        if (queue == null) {
            queue = this.createMailQueue(name);
            if (this.useJMX) {
                this.registerMBean(name, queue);
            }
            this.queues.put(name, queue);
        }
        return queue;
    }

    protected abstract MailQueue createMailQueue(String var1);

    protected synchronized void registerMBean(String queuename, MailQueue queue) {
        String mbeanName = "org.apache.james:type=component,name=queue,queue=" + queuename;
        try {
            MailQueueManagement mbean = null;
            if (queue instanceof ManageableMailQueue) {
                mbean = new MailQueueManagement((ManageableMailQueue)queue);
            } else if (queue instanceof MailQueueManagementMBean) {
                mbean = (MailQueueManagementMBean)queue;
            }
            if (mbean != null) {
                this.mbeanServer.registerMBean(mbean, new ObjectName(mbeanName));
                this.mbeans.add(mbeanName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register mbean", e);
        }
    }

    protected synchronized void unregisterMBean(String mbeanName) {
        try {
            this.mbeanServer.unregisterMBean(new ObjectName(mbeanName));
            this.mbeans.remove(mbeanName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unregister mbean", e);
        }
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

