/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.tika.detect.MagicDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;

class MagicMatch
implements Clause {
    private final MagicDetector detector;
    private final int length;

    MagicMatch(MagicDetector detector, int length) throws MimeTypeException {
        this.detector = detector;
        this.length = length;
    }

    public boolean eval(byte[] data) {
        try {
            return this.detector.detect(new ByteArrayInputStream(data), new Metadata()) != MediaType.OCTET_STREAM;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return this.detector.toString();
    }
}

