/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.GPOSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class GPOSRecordTest
extends TestCase {
    public void test_ctor_0arg() {
        GPOSRecord gr = new GPOSRecord();
        GPOSRecordTest.assertNull((Object)gr.getName());
        GPOSRecordTest.assertEquals((int)0, (int)gr.getType());
        GPOSRecordTest.assertEquals((int)0, (int)gr.getDClass());
        GPOSRecordTest.assertEquals((long)0L, (long)gr.getTTL());
    }

    public void test_getObject() {
        GPOSRecord gr = new GPOSRecord();
        Record r = gr.getObject();
        GPOSRecordTest.assertTrue((boolean)(r instanceof GPOSRecord));
    }

    public void test_rrToString() throws TextParseException {
        String exp = "\"10.45\" \"171.121212\" \"1010787.0\"";
        GPOSRecord gr = new GPOSRecord(Name.fromString("The.Name."), 1, 291L, 10.45, 171.121212, 1010787.0);
        GPOSRecordTest.assertEquals((String)exp, (String)gr.rrToString());
    }

    public void test_rrToWire() throws TextParseException {
        GPOSRecord gr = new GPOSRecord(Name.fromString("The.Name."), 1, 291L, -10.45, 120.0, 111.0);
        byte[] exp = new byte[]{6, 45, 49, 48, 46, 52, 53, 5, 49, 50, 48, 46, 48, 5, 49, 49, 49, 46, 48};
        DNSOutput out = new DNSOutput();
        gr.rrToWire(out, null, true);
        byte[] bar = out.toByteArray();
        GPOSRecordTest.assertEquals((int)exp.length, (int)bar.length);
        for (int i = 0; i < exp.length; ++i) {
            GPOSRecordTest.assertEquals((String)("i=" + i), (byte)exp[i], (byte)bar[i]);
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_Ctor_6arg_doubles.class);
        s.addTestSuite(Test_Ctor_6arg_Strings.class);
        s.addTestSuite(Test_rrFromWire.class);
        s.addTestSuite(Test_rdataFromString.class);
        s.addTestSuite(GPOSRecordTest.class);
        return s;
    }

    public static class Test_rdataFromString
    extends TestCase {
        public void test_basic() throws IOException {
            Tokenizer t = new Tokenizer("10.45 171.121212 1010787");
            GPOSRecord gr = new GPOSRecord();
            gr.rdataFromString(t, null);
            Test_rdataFromString.assertEquals((Object)new Double(10.45), (Object)new Double(gr.getLongitude()));
            Test_rdataFromString.assertEquals((Object)new Double(171.121212), (Object)new Double(gr.getLatitude()));
            Test_rdataFromString.assertEquals((Object)new Double(1010787.0), (Object)new Double(gr.getAltitude()));
        }

        public void test_longitude_toosmall() throws IOException {
            Tokenizer t = new Tokenizer("-100.390 171.121212 1010787");
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rdataFromString(t, null);
                Test_rdataFromString.fail((String)"IOException not thrown");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void test_longitude_toobig() throws IOException {
            Tokenizer t = new Tokenizer("90.00001 171.121212 1010787");
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rdataFromString(t, null);
                Test_rdataFromString.fail((String)"IOException not thrown");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void test_latitude_toosmall() throws IOException {
            Tokenizer t = new Tokenizer("0.0 -180.01 1010787");
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rdataFromString(t, null);
                Test_rdataFromString.fail((String)"IOException not thrown");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void test_latitude_toobig() throws IOException {
            Tokenizer t = new Tokenizer("0.0 180.01 1010787");
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rdataFromString(t, null);
                Test_rdataFromString.fail((String)"IOException not thrown");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void test_invalid_string() throws IOException {
            Tokenizer t = new Tokenizer("1.0 2.0 \\435");
            try {
                GPOSRecord gr = new GPOSRecord();
                gr.rdataFromString(t, null);
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }
    }

    public static class Test_rrFromWire
    extends TestCase {
        public void test_basic() throws IOException {
            byte[] raw = new byte[]{5, 45, 56, 46, 49, 50, 6, 49, 50, 51, 46, 48, 55, 3, 48, 46, 48};
            DNSInput in = new DNSInput(raw);
            GPOSRecord gr = new GPOSRecord();
            gr.rrFromWire(in);
            Test_rrFromWire.assertEquals((Object)new Double(-8.12), (Object)new Double(gr.getLongitude()));
            Test_rrFromWire.assertEquals((Object)new Double(123.07), (Object)new Double(gr.getLatitude()));
            Test_rrFromWire.assertEquals((Object)new Double(0.0), (Object)new Double(gr.getAltitude()));
        }

        public void test_longitude_toosmall() throws IOException {
            byte[] raw = new byte[]{5, 45, 57, 53, 46, 48, 6, 49, 50, 51, 46, 48, 55, 3, 48, 46, 48};
            DNSInput in = new DNSInput(raw);
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rrFromWire(in);
                Test_rrFromWire.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }

        public void test_longitude_toobig() throws IOException {
            byte[] raw = new byte[]{5, 49, 56, 53, 46, 48, 6, 49, 50, 51, 46, 48, 55, 3, 48, 46, 48};
            DNSInput in = new DNSInput(raw);
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rrFromWire(in);
                Test_rrFromWire.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }

        public void test_latitude_toosmall() throws IOException {
            byte[] raw = new byte[]{5, 45, 56, 53, 46, 48, 6, 45, 49, 57, 48, 46, 48, 3, 48, 46, 48};
            DNSInput in = new DNSInput(raw);
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rrFromWire(in);
                Test_rrFromWire.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }

        public void test_latitude_toobig() throws IOException {
            byte[] raw = new byte[]{5, 45, 56, 53, 46, 48, 6, 50, 49, 57, 48, 46, 48, 3, 48, 46, 48};
            DNSInput in = new DNSInput(raw);
            GPOSRecord gr = new GPOSRecord();
            try {
                gr.rrFromWire(in);
                Test_rrFromWire.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }
    }

    public static class Test_Ctor_6arg_Strings
    extends TestCase {
        private Name m_n;
        private long m_ttl;
        private double m_lat;
        private double m_long;
        private double m_alt;

        protected void setUp() throws TextParseException {
            this.m_n = Name.fromString("The.Name.");
            this.m_ttl = 43981L;
            this.m_lat = -10.43;
            this.m_long = 76.12;
            this.m_alt = 100.101;
        }

        public void test_basic() throws TextParseException {
            GPOSRecord gr = new GPOSRecord(this.m_n, 1, this.m_ttl, new Double(this.m_long).toString(), new Double(this.m_lat).toString(), new Double(this.m_alt).toString());
            Test_Ctor_6arg_Strings.assertEquals((Object)this.m_n, (Object)gr.getName());
            Test_Ctor_6arg_Strings.assertEquals((int)1, (int)gr.getDClass());
            Test_Ctor_6arg_Strings.assertEquals((int)27, (int)gr.getType());
            Test_Ctor_6arg_Strings.assertEquals((long)this.m_ttl, (long)gr.getTTL());
            Test_Ctor_6arg_Strings.assertEquals((Object)new Double(this.m_long), (Object)new Double(gr.getLongitude()));
            Test_Ctor_6arg_Strings.assertEquals((Object)new Double(this.m_lat), (Object)new Double(gr.getLatitude()));
            Test_Ctor_6arg_Strings.assertEquals((Object)new Double(this.m_alt), (Object)new Double(gr.getAltitude()));
            Test_Ctor_6arg_Strings.assertEquals((String)new Double(this.m_long).toString(), (String)gr.getLongitudeString());
            Test_Ctor_6arg_Strings.assertEquals((String)new Double(this.m_lat).toString(), (String)gr.getLatitudeString());
            Test_Ctor_6arg_Strings.assertEquals((String)new Double(this.m_alt).toString(), (String)gr.getAltitudeString());
        }

        public void test_toosmall_longitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, "-90.001", new Double(this.m_lat).toString(), new Double(this.m_alt).toString());
                Test_Ctor_6arg_Strings.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_longitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, "90.001", new Double(this.m_lat).toString(), new Double(this.m_alt).toString());
                Test_Ctor_6arg_Strings.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toosmall_latitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, new Double(this.m_long).toString(), "-180.001", new Double(this.m_alt).toString());
                Test_Ctor_6arg_Strings.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_latitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, new Double(this.m_long).toString(), "180.001", new Double(this.m_alt).toString());
                Test_Ctor_6arg_Strings.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static class Test_Ctor_6arg_doubles
    extends TestCase {
        private Name m_n;
        private long m_ttl;
        private double m_lat;
        private double m_long;
        private double m_alt;

        protected void setUp() throws TextParseException {
            this.m_n = Name.fromString("The.Name.");
            this.m_ttl = 43981L;
            this.m_lat = -10.43;
            this.m_long = 76.12;
            this.m_alt = 100.101;
        }

        public void test_basic() throws TextParseException {
            GPOSRecord gr = new GPOSRecord(this.m_n, 1, this.m_ttl, this.m_long, this.m_lat, this.m_alt);
            Test_Ctor_6arg_doubles.assertEquals((Object)this.m_n, (Object)gr.getName());
            Test_Ctor_6arg_doubles.assertEquals((int)1, (int)gr.getDClass());
            Test_Ctor_6arg_doubles.assertEquals((int)27, (int)gr.getType());
            Test_Ctor_6arg_doubles.assertEquals((long)this.m_ttl, (long)gr.getTTL());
            Test_Ctor_6arg_doubles.assertEquals((Object)new Double(this.m_long), (Object)new Double(gr.getLongitude()));
            Test_Ctor_6arg_doubles.assertEquals((Object)new Double(this.m_lat), (Object)new Double(gr.getLatitude()));
            Test_Ctor_6arg_doubles.assertEquals((Object)new Double(this.m_alt), (Object)new Double(gr.getAltitude()));
            Test_Ctor_6arg_doubles.assertEquals((String)new Double(this.m_long).toString(), (String)gr.getLongitudeString());
            Test_Ctor_6arg_doubles.assertEquals((String)new Double(this.m_lat).toString(), (String)gr.getLatitudeString());
            Test_Ctor_6arg_doubles.assertEquals((String)new Double(this.m_alt).toString(), (String)gr.getAltitudeString());
        }

        public void test_toosmall_longitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, -90.001, this.m_lat, this.m_alt);
                Test_Ctor_6arg_doubles.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_longitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, 90.001, this.m_lat, this.m_alt);
                Test_Ctor_6arg_doubles.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toosmall_latitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, this.m_long, -180.001, this.m_alt);
                Test_Ctor_6arg_doubles.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_toobig_latitude() throws TextParseException {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, this.m_long, 180.001, this.m_alt);
                Test_Ctor_6arg_doubles.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_invalid_string() {
            try {
                new GPOSRecord(this.m_n, 1, this.m_ttl, new Double(this.m_long).toString(), "120.\\00ABC", new Double(this.m_alt).toString());
                Test_Ctor_6arg_doubles.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

