/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Rcode;

public class RcodeTest
extends TestCase {
    public void test_string() {
        RcodeTest.assertEquals((String)"NXDOMAIN", (String)Rcode.string(3));
        RcodeTest.assertEquals((String)"NOTIMP", (String)Rcode.string(4));
        RcodeTest.assertTrue((boolean)Rcode.string(20).startsWith("RESERVED"));
        try {
            Rcode.string(-1);
            RcodeTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Rcode.string(4096);
            RcodeTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_TSIGstring() {
        RcodeTest.assertEquals((String)"BADSIG", (String)Rcode.TSIGstring(16));
        RcodeTest.assertTrue((boolean)Rcode.TSIGstring(20).startsWith("RESERVED"));
        try {
            Rcode.TSIGstring(-1);
            RcodeTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Rcode.string(65536);
            RcodeTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_value() {
        RcodeTest.assertEquals((int)1, (int)Rcode.value("FORMERR"));
        RcodeTest.assertEquals((int)4, (int)Rcode.value("NOTIMP"));
        RcodeTest.assertEquals((int)4, (int)Rcode.value("NOTIMPL"));
        RcodeTest.assertEquals((int)35, (int)Rcode.value("RESERVED35"));
        RcodeTest.assertEquals((int)-1, (int)Rcode.value("RESERVED4096"));
        RcodeTest.assertEquals((int)-1, (int)Rcode.value("THIS IS DEFINITELY UNKNOWN"));
        RcodeTest.assertEquals((int)-1, (int)Rcode.value(""));
    }
}

