/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeConverter {
    private static HashMap<String, Integer> multipliers = new HashMap(10);
    private static final String PATTERN_STRING = "\\s*([0-9]+)\\s*([a-z,A-Z]+)\\s*";
    private static Pattern PATTERN = null;

    private TimeConverter() {
    }

    public static long getMilliSeconds(long amount, String unit) throws NumberFormatException {
        Integer multiplierObject = multipliers.get(unit);
        if (multiplierObject == null) {
            throw new NumberFormatException("Unknown unit: " + unit);
        }
        int multiplier = multiplierObject;
        return amount * (long)multiplier;
    }

    public static long getMilliSeconds(String rawString) throws NumberFormatException {
        PATTERN = Pattern.compile(PATTERN_STRING);
        Matcher res = PATTERN.matcher(rawString);
        if (res.matches()) {
            if (res.group(1) != null && res.group(2) != null) {
                long time = Integer.parseInt(res.group(1).trim());
                String unit = res.group(2);
                return TimeConverter.getMilliSeconds(time, unit);
            }
            throw new NumberFormatException("The supplied String is not a supported format " + rawString);
        }
        throw new NumberFormatException("The supplied String is not a supported format " + rawString);
    }

    static {
        multipliers.put("msec", 1);
        multipliers.put("msecs", 1);
        multipliers.put("sec", 1000);
        multipliers.put("secs", 1000);
        multipliers.put("minute", 60000);
        multipliers.put("minutes", 60000);
        multipliers.put("hour", 3600000);
        multipliers.put("hours", 3600000);
        multipliers.put("day", 86400000);
        multipliers.put("days", 86400000);
        PATTERN = Pattern.compile(PATTERN_STRING);
    }
}

