/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrent;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.util.concurrent.JMXEnabledScheduledThreadPoolExecutorMBean;
import org.apache.james.util.concurrent.NamedThreadFactory;

public class JMXEnabledScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements JMXEnabledScheduledThreadPoolExecutorMBean {
    private String jmxPath;
    private final List<Runnable> inProgress = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private long totalTime;
    private int totalTasks;
    private MBeanServer mbeanServer;
    private String mbeanName;

    public JMXEnabledScheduledThreadPoolExecutor(int corePoolSize, NamedThreadFactory threadFactory, String jmxPath) {
        super(corePoolSize, threadFactory);
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    public JMXEnabledScheduledThreadPoolExecutor(int corePoolSize, String jmxPath, String name) {
        super(corePoolSize, new NamedThreadFactory(name));
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.inProgress.add(r);
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        long time = System.currentTimeMillis() - this.startTime.get();
        JMXEnabledScheduledThreadPoolExecutor jMXEnabledScheduledThreadPoolExecutor = this;
        synchronized (jMXEnabledScheduledThreadPoolExecutor) {
            this.totalTime += time;
            ++this.totalTasks;
        }
        this.inProgress.remove(r);
        super.afterExecute(r, t);
    }

    private void registerMBean() {
        if (this.jmxPath != null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.mbeanName = this.jmxPath + ",threadpool=" + ((NamedThreadFactory)this.getThreadFactory()).getName();
            try {
                this.mbeanServer.registerMBean(this, new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register mbean", e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.jmxPath != null) {
            try {
                this.mbeanServer.unregisterMBean(new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unregister mbean", e);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    @Override
    public synchronized int getTotalTasks() {
        return this.totalTasks;
    }

    @Override
    public synchronized double getAverageTaskTime() {
        return this.totalTasks == 0 ? 0.0 : (double)(this.totalTime / (long)this.totalTasks);
    }

    @Override
    public int getActiveThreads() {
        return this.getPoolSize();
    }

    @Override
    public int getActiveTasks() {
        return this.getActiveCount();
    }

    @Override
    public int getQueuedTasks() {
        return this.getQueue().size();
    }

    @Override
    public int getMaximalThreads() {
        return this.getMaximumPoolSize();
    }
}

