/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    public final String name;
    private final AtomicLong count = new AtomicLong();
    private int priority;

    public NamedThreadFactory(String name, int priority) {
        if (priority > 10 || priority < 1) {
            throw new IllegalArgumentException("Priority must be <= 10 and >=1");
        }
        this.name = name;
        this.priority = priority;
    }

    public NamedThreadFactory(String name) {
        this(name, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setName(this.name + "-" + this.count.incrementAndGet());
        t.setPriority(this.priority);
        return t;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NamedTreadFactory: " + this.getName();
    }
}

