/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.sql;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SqlResources {
    private Map<String, String> m_sql = new HashMap<String, String>();
    private Map<String, String> m_dbOptions = new HashMap<String, String>();
    private static Map<String, String> stringTable = Collections.synchronizedMap(new HashMap());

    public void init(File sqlFile, String sqlDefsSection, Connection conn, Map<String, String> configParameters) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document sqlDoc = builder.parse(sqlFile);
        this.init(sqlDoc, sqlDefsSection, conn, configParameters);
    }

    public void init(InputStream input, String sqlDefsSection, Connection conn, Map<String, String> configParameters) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document sqlDoc = builder.parse(input);
        this.init(sqlDoc, sqlDefsSection, conn, configParameters);
    }

    protected void init(Document sqlDoc, String sqlDefsSection, Connection conn, Map<String, String> configParameters) throws SQLException {
        Element dbOptionsElement;
        Element dbMatcherElement = (Element)sqlDoc.getElementsByTagName("dbMatchers").item(0);
        String dbProduct = null;
        if (dbMatcherElement != null) {
            dbProduct = this.matchDbConnection(conn, dbMatcherElement);
        }
        if ((dbOptionsElement = (Element)sqlDoc.getElementsByTagName("dbOptions").item(0)) != null) {
            this.populateDbOptions("", dbOptionsElement, this.m_dbOptions);
            if (dbProduct != null) {
                this.populateDbOptions(dbProduct, dbOptionsElement, this.m_dbOptions);
            }
        }
        NodeList sections = sqlDoc.getElementsByTagName("sqlDefs");
        int sectionsCount = sections.getLength();
        Element sectionElement = null;
        boolean found = false;
        for (int i = 0; i < sectionsCount; ++i) {
            sectionElement = (Element)sections.item(i);
            String sectionName = sectionElement.getAttribute("name");
            if (sectionName == null || !sectionName.equals(sqlDefsSection)) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuilder exceptionBuffer = new StringBuilder(64).append("Error loading sql definition file. ").append("The element named '").append(sqlDefsSection).append("' does not exist.");
            throw new RuntimeException(exceptionBuffer.toString());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Element parametersElement = (Element)sectionElement.getElementsByTagName("parameters").item(0);
        if (parametersElement != null) {
            NamedNodeMap params = parametersElement.getAttributes();
            int paramCount = params.getLength();
            for (int i = 0; i < paramCount; ++i) {
                Attr param = (Attr)params.item(i);
                String paramName = param.getName();
                String paramValue = param.getValue();
                parameters.put(paramName, paramValue);
            }
        }
        parameters.putAll(configParameters);
        HashMap<String, String> defaultSqlStatements = new HashMap<String, String>();
        HashMap dbProductSqlStatements = new HashMap();
        NodeList sqlDefs = sectionElement.getElementsByTagName("sql");
        int sqlCount = sqlDefs.getLength();
        for (int i = 0; i < sqlCount; ++i) {
            HashMap<String, String> sqlMap;
            Element sqlElement = (Element)sqlDefs.item(i);
            String sqlDb = sqlElement.getAttribute("db");
            if (sqlDb.equals("")) {
                sqlMap = defaultSqlStatements;
            } else {
                if (!sqlDb.equals(dbProduct)) continue;
                sqlMap = dbProductSqlStatements;
            }
            String sqlKey = sqlElement.getAttribute("name");
            if (sqlKey == null) continue;
            String sqlString = sqlElement.getFirstChild().getNodeValue();
            StringBuilder replaceBuffer = new StringBuilder(64);
            for (Map.Entry entry : parameters.entrySet()) {
                replaceBuffer.setLength(0);
                replaceBuffer.append("${").append((String)entry.getKey()).append("}");
                sqlString = this.substituteSubString(sqlString, replaceBuffer.toString(), (String)entry.getValue());
            }
            String shared = stringTable.get(sqlString);
            if (shared == null) {
                stringTable.put(sqlString, sqlString);
            } else {
                sqlString = shared;
            }
            sqlMap.put(sqlKey, sqlString);
        }
        this.m_sql.putAll(defaultSqlStatements);
        this.m_sql.putAll(dbProductSqlStatements);
    }

    private String matchDbConnection(Connection conn, Element dbMatchersElement) throws SQLException {
        String dbProductName = conn.getMetaData().getDatabaseProductName();
        NodeList dbMatchers = dbMatchersElement.getElementsByTagName("dbMatcher");
        for (int i = 0; i < dbMatchers.getLength(); ++i) {
            Element dbMatcher = (Element)dbMatchers.item(i);
            String dbMatchName = dbMatcher.getAttribute("db");
            Pattern dbProductPattern = Pattern.compile(dbMatcher.getAttribute("databaseProductName"), 2);
            if (!dbProductPattern.matcher(dbProductName).find()) continue;
            return dbMatchName;
        }
        return null;
    }

    private void populateDbOptions(String dbProduct, Element dbOptionsElement, Map<String, String> dbOptionsMap) {
        NodeList dbOptions = dbOptionsElement.getElementsByTagName("dbOption");
        for (int i = 0; i < dbOptions.getLength(); ++i) {
            Element dbOption = (Element)dbOptions.item(i);
            if (!dbProduct.equalsIgnoreCase(dbOption.getAttribute("db"))) continue;
            dbOptionsMap.put(dbOption.getAttribute("name"), dbOption.getAttribute("value"));
        }
    }

    private String substituteSubString(String input, String find, String replace) {
        int find_length = find.length();
        int replace_length = replace.length();
        StringBuilder output = new StringBuilder(input);
        int index = input.indexOf(find);
        int outputOffset = 0;
        while (index > -1) {
            output.replace(index + outputOffset, index + outputOffset + find_length, replace);
            outputOffset += replace_length - find_length;
            index = input.indexOf(find, index + find_length);
        }
        String result = output.toString();
        return result;
    }

    public String getSqlString(String name) {
        return this.m_sql.get(name);
    }

    public String getSqlString(String name, boolean required) {
        String sql = this.getSqlString(name);
        if (sql == null && required) {
            StringBuilder exceptionBuffer = new StringBuilder(64).append("Required SQL resource: '").append(name).append("' was not found.");
            throw new RuntimeException(exceptionBuffer.toString());
        }
        return sql;
    }

    public String getDbOption(String name) {
        return this.m_dbOptions.get(name);
    }
}

