/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.master;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.impl.store.replication.buffer.LogBufferFullException;
import org.apache.derby.impl.store.replication.buffer.ReplicationLogBuffer;
import org.apache.derby.impl.store.replication.master.AsynchronousLogShipper;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.ReplicationMessageTransmit;
import org.apache.derby.impl.store.replication.net.SlaveAddress;

public class MasterController
implements MasterFactory,
ModuleControl,
ModuleSupportable {
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x100000;
    private RawStoreFactory rawStoreFactory;
    private DataFactory dataFactory;
    private LogFactory logFactory;
    private ReplicationLogBuffer logBuffer;
    private AsynchronousLogShipper logShipper;
    private ReplicationMessageTransmit transmitter;
    private ReplicationLogger repLogger;
    private String replicationMode;
    private SlaveAddress slaveAddr;
    private String dbname;
    private int logBufferSize = 0;
    private boolean active = false;
    private static final int SLAVE_CONNECTION_ATTEMPT_TIMEOUT = 5000;

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.replicationMode = properties.getProperty("derby.__rt.replication.master.mode");
    }

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.replication.master.mode");
        return string != null && string.equals("derby.__rt.asynch");
    }

    public void stop() {
        try {
            this.stopMaster();
        }
        catch (StandardException standardException) {
            this.repLogger.logError("R008", standardException);
        }
    }

    public void startMaster(RawStoreFactory rawStoreFactory, DataFactory dataFactory, LogFactory logFactory, String string, int n, String string2) throws StandardException {
        if (this.active) {
            throw StandardException.newException("XRE22.C", string2);
        }
        try {
            this.slaveAddr = new SlaveAddress(string, new Integer(n));
        }
        catch (UnknownHostException unknownHostException) {
            throw StandardException.newException("XRE04.C.1", unknownHostException, (Object)string2, (Object)this.getHostName(), (Object)String.valueOf(this.getPortNumber()));
        }
        this.dbname = string2;
        this.rawStoreFactory = rawStoreFactory;
        this.dataFactory = dataFactory;
        this.logFactory = logFactory;
        this.repLogger = new ReplicationLogger(string2);
        this.getMasterProperties();
        this.logBuffer = new ReplicationLogBuffer(this.logBufferSize, this);
        try {
            this.logFactory.startReplicationMasterRole(this);
            this.rawStoreFactory.unfreeze();
            this.setupConnection();
            if (this.replicationMode.equals("derby.__rt.asynch")) {
                this.logShipper = new AsynchronousLogShipper(this.logBuffer, this.transmitter, this, this.repLogger);
                this.logShipper.setDaemon(true);
                this.logShipper.start();
            }
        }
        catch (StandardException standardException) {
            this.repLogger.logError("R005", standardException);
            this.logFactory.stopReplicationMasterRole();
            this.teardownNetwork();
            throw standardException;
        }
        this.active = true;
        Monitor.logTextMessage("R007", string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMaster() throws StandardException {
        block6: {
            if (!this.active) {
                throw StandardException.newException("XRE07");
            }
            this.active = false;
            this.logFactory.stopReplicationMasterRole();
            try {
                try {
                    this.logShipper.flushBuffer();
                }
                catch (IOException iOException) {
                    this.repLogger.logError("R009", iOException);
                    Object var3_2 = null;
                    this.teardownNetwork();
                    break block6;
                }
                catch (StandardException standardException) {
                    this.repLogger.logError("R009", standardException);
                    Object var3_3 = null;
                    this.teardownNetwork();
                }
                Object var3_1 = null;
                this.teardownNetwork();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.teardownNetwork();
                throw throwable;
            }
        }
        Monitor.logTextMessage("R008", this.dbname);
    }

    public void startFailover() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("XRE07");
        }
        ReplicationMessage replicationMessage = null;
        this.active = false;
        this.rawStoreFactory.freeze();
        try {
            this.logShipper.flushBuffer();
            ReplicationMessage replicationMessage2 = new ReplicationMessage(21, null);
            replicationMessage = this.transmitter.sendMessageWaitForReply(replicationMessage2);
        }
        catch (IOException iOException) {
            this.handleFailoverFailure(iOException);
        }
        catch (StandardException standardException) {
            this.handleFailoverFailure(standardException);
        }
        if (replicationMessage == null) {
            this.handleFailoverFailure(null);
        } else {
            if (replicationMessage.getType() == 11) {
                this.teardownNetwork();
                this.rawStoreFactory.unfreeze();
                throw StandardException.newException("XRE20.D", this.dbname);
            }
            this.handleFailoverFailure(null);
        }
    }

    private void getMasterProperties() {
        this.logBufferSize = PropertyUtil.getSystemInt("derby.replication.logBufferSize", 32768);
        if (this.logBufferSize < 8192) {
            this.logBufferSize = 8192;
        } else if (this.logBufferSize > 0x100000) {
            this.logBufferSize = 0x100000;
        }
    }

    private void handleFailoverFailure(Throwable throwable) throws StandardException {
        this.teardownNetwork();
        this.rawStoreFactory.unfreeze();
        if (throwable != null) {
            throw StandardException.newException("XRE21.C", throwable, (Object)this.dbname);
        }
        throw StandardException.newException("XRE21.C", this.dbname);
    }

    public void appendLog(long l, byte[] byArray, int n, int n2) {
        try {
            this.logBuffer.appendLog(l, byArray, n, n2);
        }
        catch (LogBufferFullException logBufferFullException) {
            try {
                this.logShipper.forceFlush();
                this.logBuffer.appendLog(l, byArray, n, n2);
            }
            catch (LogBufferFullException logBufferFullException2) {
                this.printStackAndStopMaster(logBufferFullException2);
            }
            catch (IOException iOException) {
                this.printStackAndStopMaster(iOException);
            }
            catch (StandardException standardException) {
                this.printStackAndStopMaster(standardException);
            }
        }
    }

    public void flushedTo(long l) {
        this.logShipper.flushedInstance(l);
    }

    private void setupConnection() throws StandardException {
        try {
            if (this.transmitter != null) {
                this.transmitter.tearDown();
            }
            this.transmitter = new ReplicationMessageTransmit(this.slaveAddr);
            if (this.logShipper != null && this.logShipper.getHighestShippedInstant() != -1L) {
                this.transmitter.initConnection(5000, this.logShipper.getHighestShippedInstant());
            } else {
                this.transmitter.initConnection(5000, this.logFactory.getFirstUnflushedInstantAsLong());
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw StandardException.newException("XRE06", this.dbname);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XRE04.C.1", iOException, (Object)this.dbname, (Object)this.getHostName(), (Object)String.valueOf(this.getPortNumber()));
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Exception exception) {
            throw StandardException.newException("XRE04.C.1", exception, (Object)this.dbname, (Object)this.getHostName(), (Object)String.valueOf(this.getPortNumber()));
        }
    }

    ReplicationMessageTransmit handleExceptions(Exception exception) {
        if (exception instanceof IOException) {
            this.repLogger.logError("R009", exception);
            Monitor.logTextMessage("R010", this.dbname);
            while (this.active) {
                try {
                    this.transmitter = new ReplicationMessageTransmit(this.slaveAddr);
                    if (this.logShipper != null && this.logShipper.getHighestShippedInstant() != -1L) {
                        this.transmitter.initConnection(5000, this.logShipper.getHighestShippedInstant());
                    } else {
                        this.transmitter.initConnection(5000, this.logFactory.getFirstUnflushedInstantAsLong());
                    }
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                }
                catch (Exception exception2) {
                    this.printStackAndStopMaster(exception2);
                    return null;
                }
            }
        } else if (exception instanceof StandardException) {
            this.printStackAndStopMaster(exception);
            return null;
        }
        return this.transmitter;
    }

    private void printStackAndStopMaster(Exception exception) {
        this.repLogger.logError("R009", exception);
        try {
            this.stopMaster();
        }
        catch (StandardException standardException) {
            this.repLogger.logError("R008", standardException);
        }
    }

    public void workToDo() {
        this.logShipper.workToDo();
    }

    private void teardownNetwork() {
        if (this.logShipper != null) {
            this.logShipper.stopLogShipment();
        }
        if (this.transmitter != null) {
            try {
                ReplicationMessage replicationMessage = new ReplicationMessage(20, null);
                this.transmitter.sendMessage(replicationMessage);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.transmitter.tearDown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    String getDbName() {
        return this.dbname;
    }

    private String getHostName() {
        return this.slaveAddr.getHostAddress().getHostName();
    }

    private int getPortNumber() {
        return this.slaveAddr.getPortNumber();
    }
}

