/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.StoreRequest;

public class StoreCommandParser
extends AbstractUidCommandParser {
    public StoreCommandParser() {
        super(ImapCommand.selectedStateCommand((String)"STORE"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        Boolean sign;
        IdRange[] idSet = request.parseIdRange(session);
        boolean silent = false;
        char next = request.nextWordChar();
        if (next == '+') {
            sign = Boolean.TRUE;
            request.consume();
        } else if (next == '-') {
            sign = Boolean.FALSE;
            request.consume();
        } else {
            sign = null;
        }
        String directive = request.consumeWord(new ImapRequestLineReader.NoopCharValidator());
        if ("FLAGS".equalsIgnoreCase(directive)) {
            silent = false;
        } else if ("FLAGS.SILENT".equalsIgnoreCase(directive)) {
            silent = true;
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid Store Directive: '" + directive + "'");
        }
        Flags flags = new Flags();
        if (request.nextWordChar() == '(') {
            flags.add(request.flagList());
        } else {
            boolean moreFlags = true;
            while (moreFlags) {
                flags.add(request.flag());
                try {
                    request.consumeChar(' ');
                }
                catch (DecodingException e) {
                    moreFlags = false;
                }
            }
        }
        request.eol();
        StoreRequest result = new StoreRequest(command, idSet, silent, flags, useUids, tag, sign);
        return result;
    }
}

