/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ExistsResponse;

public class ExistsResponseEncoder
extends AbstractChainedImapEncoder {
    public ExistsResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof ExistsResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        ExistsResponse existsResponse = (ExistsResponse)acceptableMessage;
        long numberOfMessages = existsResponse.getNumberOfMessages();
        composer.existsResponse(numberOfMessages);
    }
}

