/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.FlagsResponse;

public class FlagsResponseEncoder
extends AbstractChainedImapEncoder {
    public FlagsResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof FlagsResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        FlagsResponse flagsResponse = (FlagsResponse)acceptableMessage;
        Flags flags = flagsResponse.getFlags();
        composer.flagsResponse(flags);
    }
}

