/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.AbstractListingResponse;

public class ListingEncodingUtils {
    public static void encodeListingResponse(String responseTypeName, ImapResponseComposer composer, AbstractListingResponse response) throws IOException {
        List<String> attributes = ListingEncodingUtils.getNameAttributes(response);
        String name = response.getName();
        composer.listResponse(responseTypeName, attributes, response.getHierarchyDelimiter(), name);
    }

    private static List<String> getNameAttributes(AbstractListingResponse response) {
        ArrayList<String> attributes;
        if (response.isNameAttributed()) {
            attributes = new ArrayList<String>();
            if (response.isNoInferiors()) {
                attributes.add("\\Noinferiors");
            }
            if (response.isNoSelect()) {
                attributes.add("\\Noselect");
            }
            if (response.isMarked()) {
                attributes.add("\\Marked");
            }
            if (response.isUnmarked()) {
                attributes.add("\\Unmarked");
            }
            if (response.hasChildren()) {
                attributes.add("\\HasChildren");
            }
            if (response.hasNoChildren()) {
                attributes.add("\\HasNoChildren");
            }
            if (!MailboxType.OTHER.equals((Object)response.getType())) {
                attributes.add(response.getType().getAttributeName());
            }
        } else {
            attributes = null;
        }
        return attributes;
    }
}

