/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.RecentResponse;

public class RecentResponseEncoder
extends AbstractChainedImapEncoder {
    public RecentResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof RecentResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        RecentResponse recentResponse = (RecentResponse)acceptableMessage;
        int numberFlaggedRecent = recentResponse.getNumberFlaggedRecent();
        composer.recentResponse(numberFlaggedRecent);
    }
}

