/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.Locales;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;

public class StatusResponseEncoder
extends AbstractChainedImapEncoder {
    private final Localizer localizer;

    public StatusResponseEncoder(ImapEncoder next, Localizer localizer) {
        super(next);
        this.localizer = localizer;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        boolean useParens;
        long number;
        Collection parameters;
        StatusResponse response = (StatusResponse)acceptableMessage;
        StatusResponse.Type serverResponseType = response.getServerResponseType();
        String type = this.asString(serverResponseType);
        StatusResponse.ResponseCode responseCode = response.getResponseCode();
        String code = this.asString(responseCode);
        String tag = response.getTag();
        ImapCommand command = response.getCommand();
        HumanReadableText textKey = response.getTextKey();
        String text = this.asString(textKey, session);
        if (responseCode == null) {
            parameters = null;
            number = 0L;
            useParens = false;
        } else {
            parameters = responseCode.getParameters();
            number = responseCode.getNumber();
            useParens = responseCode.useParens();
        }
        composer.statusResponse(tag, command, type, code, parameters, useParens, number, text);
    }

    private String asString(HumanReadableText text, ImapSession session) {
        return this.localizer.localize(text, new Locales(new ArrayList(), null));
    }

    private String asString(StatusResponse.ResponseCode code) {
        String result = code == null ? null : code.getCode();
        return result;
    }

    private String asString(StatusResponse.Type type) {
        String result = type == null ? null : type.getCode();
        return result;
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof StatusResponse;
    }
}

