/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.response.Literal;

public class ImapResponseComposerImpl
implements ImapConstants,
ImapResponseComposer {
    public static final String ENVELOPE = "ENVELOPE";
    public static final String FETCH = "FETCH";
    public static final String EXPUNGE = "EXPUNGE";
    public static final String RECENT = "RECENT";
    public static final String EXISTS = "EXISTS";
    public static final String FLAGS = "FLAGS";
    public static final String FAILED = "failed.";
    private final ImapResponseWriter writer;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private static final int LOWER_CASE_OFFSET = 32;
    private final Charset usAscii = Charset.forName("US-ASCII");
    private boolean skipNextSpace = false;

    public ImapResponseComposerImpl(ImapResponseWriter writer) {
        this.writer = writer;
    }

    @Override
    public ImapResponseComposer untaggedNoResponse(String displayMessage, String responseCode) throws IOException {
        this.untagged();
        this.message("NO");
        this.responseCode(responseCode);
        this.message(displayMessage);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer continuationResponse(String message) throws IOException {
        this.writeASCII("+ " + message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer flagsResponse(Flags flags) throws IOException {
        this.untagged();
        this.flags(flags);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer existsResponse(long count) throws IOException {
        this.untagged();
        this.message(count);
        this.message(EXISTS);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer recentResponse(long count) throws IOException {
        this.untagged();
        this.message(count);
        this.message(RECENT);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer expungeResponse(long msn) throws IOException {
        this.untagged();
        this.message(msn);
        this.message(EXPUNGE);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer commandResponse(ImapCommand command, String message) throws IOException {
        this.untagged();
        this.commandName(command.getName());
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer taggedResponse(String message, String tag) throws IOException {
        this.tag(tag);
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer untaggedResponse(String message) throws IOException {
        this.untagged();
        this.message(message);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer byeResponse(String message) throws IOException {
        this.untaggedResponse("BYE " + message);
        return this;
    }

    @Override
    public ImapResponseComposer hello(String message) throws IOException {
        this.untaggedResponse("OK " + message);
        return this;
    }

    @Override
    public ImapResponseComposer untagged() throws IOException {
        this.writeASCII("*");
        return this;
    }

    @Override
    public ImapResponseComposer message(String message) throws IOException {
        if (message != null) {
            this.space();
            this.writeASCII(message);
        }
        return this;
    }

    private void responseCode(String responseCode) throws IOException {
        if (responseCode != null && !"".equals(responseCode)) {
            this.writeASCII(" [");
            this.writeASCII(responseCode);
            this.buffer.write(93);
        }
    }

    @Override
    public ImapResponseComposer end() throws IOException {
        this.buffer.write("\r\n".getBytes());
        this.writer.write(ByteBuffer.wrap(this.buffer.toByteArray()));
        this.buffer.reset();
        return this;
    }

    @Override
    public ImapResponseComposer tag(String tag) throws IOException {
        this.writeASCII(tag);
        return this;
    }

    @Override
    public ImapResponseComposer statusResponse(String tag, ImapCommand command, String type, String responseCode, Collection<String> parameters, boolean useParens, long number, String text) throws IOException {
        if (tag == null) {
            this.untagged();
        } else {
            this.tag(tag);
        }
        this.message(type);
        if (responseCode != null) {
            this.openSquareBracket();
            this.message(responseCode);
            if (number > 0L) {
                this.message(number);
            }
            if (parameters != null && !parameters.isEmpty()) {
                if (useParens) {
                    this.openParen();
                }
                for (String parameter : parameters) {
                    this.message(parameter);
                }
                if (useParens) {
                    this.closeParen();
                }
            }
            this.closeSquareBracket();
        }
        if (command != null) {
            this.commandName(command.getName());
        }
        if (text != null && !"".equals(text)) {
            this.message(text);
        }
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer statusResponse(Long messages, Long recent, Long uidNext, Long uidValidity, Long unseen, String mailboxName) throws IOException {
        this.untagged();
        this.message("STATUS");
        this.quote(mailboxName);
        this.openParen();
        if (messages != null) {
            this.message("MESSAGES");
            long messagesValue = messages;
            this.message(messagesValue);
        }
        if (recent != null) {
            this.message(RECENT);
            long recentValue = recent;
            this.message(recentValue);
        }
        if (uidNext != null) {
            this.message("UIDNEXT");
            long uidNextValue = uidNext;
            this.message(uidNextValue);
        }
        if (uidValidity != null) {
            this.message("UIDVALIDITY");
            long uidValidityValue = uidValidity;
            this.message(uidValidityValue);
        }
        if (unseen != null) {
            this.message("UNSEEN");
            long unseenValue = unseen;
            this.message(unseenValue);
        }
        this.closeParen();
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer listResponse(String typeName, List<String> attributes, char hierarchyDelimiter, String name) throws IOException {
        this.untagged();
        this.message(typeName);
        this.openParen();
        if (attributes != null) {
            for (String attribute : attributes) {
                this.message(attribute);
            }
        }
        this.closeParen();
        if (hierarchyDelimiter == '\u0000') {
            this.message("NIL");
        } else {
            this.quote(Character.toString(hierarchyDelimiter));
        }
        this.quote(name);
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer closeParen() throws IOException {
        this.closeBracket((byte)41);
        return this;
    }

    @Override
    public ImapResponseComposer openParen() throws IOException {
        this.openBracket((byte)40);
        return this;
    }

    @Override
    public ImapResponseComposer searchResponse(long[] ids) throws IOException {
        this.untagged();
        this.message("SEARCH");
        this.message(ids);
        this.end();
        return this;
    }

    private void message(long[] ids) throws IOException {
        if (ids != null) {
            for (long id : ids) {
                this.message(id);
            }
        }
    }

    @Override
    public ImapResponseComposer flags(Flags flags) throws IOException {
        this.message(FLAGS);
        this.openParen();
        if (flags.contains(Flags.Flag.ANSWERED)) {
            this.message("\\Answered");
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            this.message("\\Deleted");
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            this.message("\\Draft");
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            this.message("\\Flagged");
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            this.message("\\Recent");
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            this.message("\\Seen");
        }
        String[] userFlags = flags.getUserFlags();
        for (int i = 0; i < userFlags.length; ++i) {
            this.message(userFlags[i]);
        }
        this.closeParen();
        return this;
    }

    @Override
    public ImapResponseComposer closeFetchResponse() throws IOException {
        this.closeParen();
        this.end();
        return this;
    }

    @Override
    public ImapResponseComposer openFetchResponse(long msn) throws IOException {
        this.untagged();
        this.message(msn);
        this.message(FETCH);
        this.openParen();
        return this;
    }

    @Override
    public ImapResponseComposer address(String name, String domainList, String mailbox, String host) throws IOException {
        this.skipNextSpace();
        this.openParen();
        this.nillableQuote(name);
        this.nillableQuote(domainList);
        this.nillableQuote(mailbox);
        this.nillableQuote(host);
        this.closeParen();
        return this;
    }

    @Override
    public ImapResponseComposer endAddresses() throws IOException {
        this.closeParen();
        return this;
    }

    @Override
    public ImapResponseComposer endEnvelope(String inReplyTo, String messageId) throws IOException {
        this.nillableQuote(inReplyTo);
        this.nillableQuote(messageId);
        this.closeParen();
        return this;
    }

    @Override
    public ImapResponseComposer nil() throws IOException {
        this.message("NIL");
        return this;
    }

    @Override
    public ImapResponseComposer startAddresses() throws IOException {
        this.openParen();
        return this;
    }

    @Override
    public ImapResponseComposer startEnvelope(String date, String subject, boolean prefixWithName) throws IOException {
        if (prefixWithName) {
            this.message(ENVELOPE);
        }
        this.openParen();
        this.nillableQuote(date);
        this.nillableQuote(subject);
        return this;
    }

    @Override
    public ImapResponseComposer nillableQuote(String message) throws IOException {
        if (message == null) {
            this.nil();
        } else {
            this.quote(message);
        }
        return this;
    }

    @Override
    public ImapResponseComposer nillableComposition(String masterQuote, List<String> quotes) throws IOException {
        if (masterQuote == null) {
            this.nil();
        } else {
            this.openParen();
            this.quote(masterQuote);
            this.nillableQuotes(quotes);
            this.closeParen();
        }
        return this;
    }

    @Override
    public ImapResponseComposer nillableQuotes(List<String> quotes) throws IOException {
        if (quotes == null || quotes.size() == 0) {
            this.nil();
        } else {
            this.openParen();
            for (String string : quotes) {
                this.nillableQuote(string);
            }
            this.closeParen();
        }
        return this;
    }

    @Override
    public ImapResponseComposer upperCaseAscii(String message) throws IOException {
        if (message == null) {
            this.nil();
        } else {
            this.upperCaseAscii(message, false);
        }
        return this;
    }

    @Override
    public ImapResponseComposer quoteUpperCaseAscii(String message) throws IOException {
        if (message == null) {
            this.nil();
        } else {
            this.upperCaseAscii(message, true);
        }
        return this;
    }

    @Override
    public ImapResponseComposer capabilities(List<String> capabilities) throws IOException {
        this.untagged();
        this.message("CAPABILITY");
        for (String capability : capabilities) {
            this.message(capability);
        }
        this.end();
        return this;
    }

    private void writeASCII(String string) throws IOException {
        this.buffer.write(string.getBytes(this.usAscii));
    }

    @Override
    public ImapResponseComposer message(long number) throws IOException {
        this.space();
        this.writeASCII(Long.toString(number));
        return this;
    }

    @Override
    public ImapResponseComposer commandName(String commandName) throws IOException {
        this.space();
        this.writeASCII(commandName);
        return this;
    }

    @Override
    public ImapResponseComposer quote(String message) throws IOException {
        this.space();
        int length = message.length();
        this.buffer.write(34);
        for (int i = 0; i < length; ++i) {
            char character = message.charAt(i);
            if (character == '\\' || character == '\"') {
                this.buffer.write(92);
            }
            if (character > '\u0080') {
                this.buffer.write(63);
                continue;
            }
            this.buffer.write((int)((byte)character));
        }
        this.buffer.write(34);
        return this;
    }

    private void closeBracket(byte bracket) throws IOException {
        this.buffer.write((int)bracket);
        this.clearSkipNextSpace();
    }

    private void openBracket(byte bracket) throws IOException {
        this.space();
        this.buffer.write((int)bracket);
        this.skipNextSpace();
    }

    private void clearSkipNextSpace() {
        this.skipNextSpace = false;
    }

    @Override
    public ImapResponseComposer skipNextSpace() {
        this.skipNextSpace = true;
        return this;
    }

    private void space() throws IOException {
        if (this.skipNextSpace) {
            this.skipNextSpace = false;
        } else {
            this.buffer.write(" ".getBytes());
        }
    }

    @Override
    public ImapResponseComposer literal(Literal literal) throws IOException {
        this.space();
        this.buffer.write(123);
        long size = literal.size();
        this.writeASCII(Long.toString(size));
        this.buffer.write(125);
        this.end();
        if (size > 0L) {
            this.writer.write(literal);
        }
        return this;
    }

    private void closeSquareBracket() throws IOException {
        this.closeBracket((byte)93);
    }

    private void openSquareBracket() throws IOException {
        this.openBracket((byte)91);
    }

    private void upperCaseAscii(String message, boolean quote) throws IOException {
        this.space();
        int length = message.length();
        if (quote) {
            this.buffer.write(34);
        }
        for (int i = 0; i < length; ++i) {
            char next = message.charAt(i);
            if (next >= 'a' && next <= 'z') {
                this.buffer.write((int)((byte)(next - 32)));
                continue;
            }
            this.buffer.write((int)((byte)next));
        }
        if (quote) {
            this.buffer.write(34);
        }
    }

    @Override
    public ImapResponseComposer sequenceSet(IdRange[] ranges) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            IdRange range = ranges[i];
            sb.append(range.getFormattedString());
            if (i + 1 >= ranges.length) continue;
            sb.append(",");
        }
        return this.message(sb.toString());
    }
}

