/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import org.slf4j.Logger;
import org.slf4j.Marker;

public class ContextualLog
implements Logger {
    private final Object context;
    private final Logger decoratedLog;

    public ContextualLog(Object context, Logger decoratedLog) {
        this.context = context;
        this.decoratedLog = decoratedLog;
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            if (this.context == null) {
                this.decoratedLog.debug(message);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString());
            }
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            if (this.context == null) {
                this.decoratedLog.debug(message, t);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString(), t);
            }
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            if (this.context == null) {
                this.decoratedLog.error(message);
            } else {
                this.decoratedLog.error(new Message(this.context, message).toString());
            }
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            if (this.context == null) {
                this.decoratedLog.error(message, t);
            } else {
                this.decoratedLog.error(new Message(this.context, message).toString(), t);
            }
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            if (this.context == null) {
                this.decoratedLog.info(message);
            } else {
                this.decoratedLog.info(new Message(this.context, message).toString());
            }
        }
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            if (this.context == null) {
                this.decoratedLog.info(message, t);
            } else {
                this.decoratedLog.info(new Message(this.context, message).toString(), t);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.decoratedLog.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.decoratedLog.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.decoratedLog.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.decoratedLog.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.decoratedLog.isWarnEnabled();
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            if (this.context == null) {
                this.decoratedLog.trace(message);
            } else {
                this.decoratedLog.trace(new Message(this.context, message).toString());
            }
        }
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            if (this.context == null) {
                this.decoratedLog.trace(message, t);
            } else {
                this.decoratedLog.trace(new Message(this.context, message).toString(), t);
            }
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString());
            }
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, t);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), t);
            }
        }
    }

    public String toString() {
        String result = "ContextualLog ( context = " + this.context + " )";
        return result;
    }

    public String getName() {
        return this.decoratedLog.getName();
    }

    public void trace(String message, Object arg) {
        if (this.isTraceEnabled()) {
            if (this.context == null) {
                this.decoratedLog.trace(message, arg);
            } else {
                this.decoratedLog.trace(new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void trace(String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            if (this.context == null) {
                this.decoratedLog.trace(message, arg1, arg2);
            } else {
                this.decoratedLog.trace(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void trace(String message, Object[] argArray) {
        if (this.isTraceEnabled()) {
            if (this.context == null) {
                this.decoratedLog.trace(message, argArray);
            } else {
                this.decoratedLog.trace(new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.decoratedLog.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.trace(marker, msg);
            } else {
                this.decoratedLog.trace(marker, new Message(this.context, msg).toString());
            }
        }
    }

    public void trace(Marker marker, String message, Object arg) {
        if (this.isTraceEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.trace(marker, message, arg);
            } else {
                this.decoratedLog.trace(marker, new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void trace(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.trace(marker, message, arg1, arg2);
            } else {
                this.decoratedLog.trace(marker, new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void trace(Marker marker, String message, Object[] argArray) {
        if (this.isTraceEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.trace(marker, message, argArray);
            } else {
                this.decoratedLog.trace(marker, new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.trace(marker, msg, t);
            } else {
                this.decoratedLog.trace(marker, new Message(this.context, msg).toString(), t);
            }
        }
    }

    public void debug(String message, Object arg) {
        if (this.isDebugEnabled()) {
            if (this.context == null) {
                this.decoratedLog.debug(message, arg);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            if (this.context == null) {
                this.decoratedLog.debug(message, arg1, arg2);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void debug(String message, Object[] argArray) {
        if (this.isDebugEnabled()) {
            if (this.context == null) {
                this.decoratedLog.debug(message, argArray);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.decoratedLog.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.debug(marker, msg);
            } else {
                this.decoratedLog.debug(marker, new Message(this.context, msg).toString());
            }
        }
    }

    public void debug(Marker marker, String message, Object arg) {
        if (this.isDebugEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.debug(marker, message, arg);
            } else {
                this.decoratedLog.debug(marker, new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void debug(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.debug(marker, message, arg1, arg2);
            } else {
                this.decoratedLog.debug(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void debug(Marker marker, String message, Object[] argArray) {
        if (this.isDebugEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.debug(marker, message, argArray);
            } else {
                this.decoratedLog.debug(marker, new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.debug(marker, msg, t);
            } else {
                this.decoratedLog.debug(marker, new Message(this.context, msg).toString(), t);
            }
        }
    }

    public void info(String message, Object arg) {
        if (this.isInfoEnabled()) {
            if (this.context == null) {
                this.decoratedLog.info(message, arg);
            } else {
                this.decoratedLog.info(new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void info(String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            if (this.context == null) {
                this.decoratedLog.info(message, arg1, arg2);
            } else {
                this.decoratedLog.info(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void info(String message, Object[] argArray) {
        if (this.isInfoEnabled()) {
            if (this.context == null) {
                this.decoratedLog.info(message, argArray);
            } else {
                this.decoratedLog.info(new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.decoratedLog.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.info(marker, msg);
            } else {
                this.decoratedLog.info(marker, new Message(this.context, msg).toString());
            }
        }
    }

    public void info(Marker marker, String message, Object arg) {
        if (this.isInfoEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.info(marker, message, arg);
            } else {
                this.decoratedLog.info(marker, new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void info(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.info(marker, message, arg1, arg2);
            } else {
                this.decoratedLog.info(marker, new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void info(Marker marker, String message, Object[] argArray) {
        if (this.isInfoEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.info(marker, message, argArray);
            } else {
                this.decoratedLog.info(marker, new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.info(marker, msg, t);
            } else {
                this.decoratedLog.info(marker, new Message(this.context, msg).toString(), t);
            }
        }
    }

    public void warn(String message, Object arg) {
        if (this.isWarnEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, arg);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void warn(String message, Object[] argArray) {
        if (this.isWarnEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, argArray);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void warn(String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, arg1, arg2);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.decoratedLog.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, msg);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, msg).toString());
            }
        }
    }

    public void warn(Marker marker, String message, Object arg) {
        if (this.isWarnEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, arg);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void warn(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, arg1, arg2);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void warn(Marker marker, String message, Object[] argArray) {
        if (this.isWarnEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, argArray);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, msg, t);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, msg).toString(), t);
            }
        }
    }

    public void error(String message, Object arg) {
        if (this.isErrorEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, arg);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void error(String message, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, arg1, arg2);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void error(String message, Object[] argArray) {
        if (this.isErrorEnabled()) {
            if (this.context == null) {
                this.decoratedLog.warn(message, argArray);
            } else {
                this.decoratedLog.warn(new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.decoratedLog.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(msg);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, msg).toString());
            }
        }
    }

    public void error(Marker marker, String message, Object arg) {
        if (this.isErrorEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, arg);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), arg);
            }
        }
    }

    public void error(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, arg1, arg2);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), arg1, arg2);
            }
        }
    }

    public void error(Marker marker, String message, Object[] argArray) {
        if (this.isErrorEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, message, argArray);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, message).toString(), argArray);
            }
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            if (this.context == null) {
                this.decoratedLog.warn(marker, msg, t);
            } else {
                this.decoratedLog.warn(marker, new Message(this.context, msg).toString(), t);
            }
        }
    }

    public static final class Message {
        private final Object context;
        private final Object message;

        public Message(Object context, Object message) {
            this.context = context;
            this.message = message;
        }

        public Object getContext() {
            return this.context;
        }

        public Object getMessage() {
            return this.message;
        }

        public String toString() {
            return this.context + " " + this.message;
        }
    }
}

