/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.jsieve.ComparatorManager;
import org.apache.jsieve.comparators.Comparator;
import org.apache.jsieve.exception.LookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorManagerImpl
implements ComparatorManager {
    private final ConcurrentMap<String, String> classNameMap;
    private final CopyOnWriteArraySet<String> implicitlyDeclared;

    public static CopyOnWriteArraySet<String> standardDefinedComparators() {
        CopyOnWriteArraySet<String> results = new CopyOnWriteArraySet<String>();
        results.add("i;octet");
        results.add("i;ascii-casemap");
        return results;
    }

    public ComparatorManagerImpl(ConcurrentMap<String, String> classNameMap) {
        this(classNameMap, ComparatorManagerImpl.standardDefinedComparators());
    }

    public ComparatorManagerImpl(ConcurrentMap<String, String> classNameMap, CopyOnWriteArraySet<String> implicitlyDeclared) {
        this.classNameMap = classNameMap;
        this.implicitlyDeclared = implicitlyDeclared;
    }

    @Override
    public boolean isImplicitlyDeclared(String comparatorName) {
        return this.implicitlyDeclared.contains(comparatorName);
    }

    public Class lookup(String name) throws LookupException {
        Class<?> comparatorClass = null;
        try {
            comparatorClass = this.getClass().getClassLoader().loadClass(this.getClassName(name));
        }
        catch (ClassNotFoundException e) {
            throw new LookupException("Comparator named '" + name + "' not found.");
        }
        if (!Comparator.class.isAssignableFrom(comparatorClass)) {
            throw new LookupException("Class " + comparatorClass.getName() + " must implement " + Comparator.class.getName());
        }
        return comparatorClass;
    }

    @Override
    public Comparator getComparator(String name) throws LookupException {
        try {
            return (Comparator)this.lookup(name).newInstance();
        }
        catch (InstantiationException e) {
            throw new LookupException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new LookupException(e.getMessage());
        }
    }

    private String getClassName(String name) throws LookupException {
        String className = (String)this.classNameMap.get(name.toLowerCase());
        if (null == className) {
            throw new LookupException("Comparator named '" + name + "' not mapped.");
        }
        return className;
    }

    @Override
    public boolean isSupported(String name) {
        try {
            this.getComparator(name);
            return true;
        }
        catch (LookupException e) {
            return false;
        }
    }
}

