/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import org.apache.commons.logging.Log;
import org.apache.jsieve.exception.CommandException;
import org.apache.jsieve.exception.SyntaxException;

public final class ScriptCoordinate {
    private final int startLineNumber;
    private final int startColumnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;
    private Log log;

    public ScriptCoordinate(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.startLineNumber = startLineNumber;
        this.startColumnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log logger) {
        this.log = logger;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public SyntaxException syntaxException(CharSequence message) {
        if (this.log != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)message);
            }
            this.logDiagnosticsInfo(this.log);
        }
        String fullMessage = this.addStartLineAndColumn(message);
        SyntaxException result = new SyntaxException(fullMessage);
        return result;
    }

    public CommandException commandException(CharSequence message) {
        if (this.log != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)message);
            }
            this.logDiagnosticsInfo(this.log);
        }
        String fullMessage = this.addStartLineAndColumn(message);
        CommandException result = new CommandException(fullMessage);
        return result;
    }

    public String addStartLineAndColumn(CharSequence message) {
        StringBuilder buffer = message instanceof StringBuilder ? (StringBuilder)message : new StringBuilder(((Object)message).toString());
        buffer.append(" Line ");
        buffer.append(this.startLineNumber);
        buffer.append(" column ");
        buffer.append(this.startColumnNumber);
        buffer.append(".");
        return buffer.toString();
    }

    public void logDiagnosticsInfo(Log logger) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Expression starts line " + this.startLineNumber + " column " + this.startColumnNumber));
            logger.info((Object)("Expression ends line " + this.endLineNumber + " column " + this.endColumnNumber));
        }
    }

    public void debugDiagnostics(Log logger) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expression starts line " + this.startLineNumber + " column " + this.startColumnNumber));
            logger.debug((Object)("Expression ends line " + this.endLineNumber + " column " + this.endColumnNumber));
        }
    }
}

