/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.jsieve.CommandManager;
import org.apache.jsieve.ComparatorManager;
import org.apache.jsieve.Constants;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.TestManager;
import org.apache.jsieve.exception.LookupException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.parser.generated.ASTargument;
import org.apache.jsieve.parser.generated.ASTarguments;
import org.apache.jsieve.parser.generated.ASTblock;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTcommands;
import org.apache.jsieve.parser.generated.ASTstart;
import org.apache.jsieve.parser.generated.ASTstring;
import org.apache.jsieve.parser.generated.ASTstring_list;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.ASTtest_list;
import org.apache.jsieve.parser.generated.SieveParserVisitor;
import org.apache.jsieve.parser.generated.SimpleNode;

public class SieveValidationVisitor
implements SieveParserVisitor {
    private final CommandManager commandManager;
    private final TestManager testManager;
    private final ComparatorManager comparatorManager;
    private final Set<String> declaredComparators;
    private boolean requireAllowed = true;
    private boolean isInRequire = false;
    private boolean nextArgumentIsComparatorName = false;
    private boolean isInComparatorNameArgument = false;

    protected SieveValidationVisitor(CommandManager commandManager, TestManager testManager, ComparatorManager comparatorManager) {
        this.commandManager = commandManager;
        this.testManager = testManager;
        this.comparatorManager = comparatorManager;
        this.declaredComparators = new HashSet<String>();
    }

    public Object visit(SimpleNode node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }

    private Object visitNode(SimpleNode node, Object data) throws SieveException {
        ArrayList children = new ArrayList(node.jjtGetNumChildren());
        node.childrenAccept(this, children);
        return data;
    }

    public Object visit(ASTstart node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }

    public Object visit(ASTcommands node, Object data) throws SieveException {
        this.declaredComparators.clear();
        return this.visitNode(node, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ASTcommand node, Object data) throws SieveException {
        String name = node.getName();
        this.commandManager.getCommand(name);
        if ("require".equalsIgnoreCase(name)) {
            if (!this.requireAllowed) throw new SieveException("'require' is only allowed before other commands");
            this.isInRequire = true;
            return this.visitNode(node, data);
        } else {
            this.requireAllowed = false;
            this.isInRequire = false;
        }
        return this.visitNode(node, data);
    }

    public Object visit(ASTblock node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }

    public Object visit(ASTarguments node, Object data) throws SieveException {
        this.nextArgumentIsComparatorName = false;
        return this.visitNode(node, data);
    }

    public Object visit(ASTargument node, Object data) throws SieveException {
        Object value = node.getValue();
        if (value == null) {
            if (this.nextArgumentIsComparatorName) {
                this.isInComparatorNameArgument = true;
            }
            this.nextArgumentIsComparatorName = false;
        } else if (value instanceof TagArgument) {
            TagArgument tag = (TagArgument)value;
            this.nextArgumentIsComparatorName = tag.isComparator();
        } else {
            this.nextArgumentIsComparatorName = false;
        }
        Object result = this.visitNode(node, data);
        this.isInComparatorNameArgument = false;
        return result;
    }

    public Object visit(ASTtest node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }

    public Object visit(ASTtest_list node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }

    public Object visit(ASTstring node, Object data) throws SieveException {
        if (this.isInRequire) {
            this.requirements(node);
        }
        if (this.isInComparatorNameArgument) {
            this.comparatorNameArgument(node);
        }
        return this.visitNode(node, data);
    }

    private void comparatorNameArgument(ASTstring node) throws SieveException {
        String name;
        Object value = node.getValue();
        if (value != null && value instanceof String && !this.comparatorManager.isImplicitlyDeclared(name = (String)value) && !this.declaredComparators.contains(name)) {
            throw new SieveException("Comparator must be explicitly declared in a require statement.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void requirements(ASTstring node) throws SieveException {
        Object value = node.getValue();
        if (value == null || !(value instanceof String)) return;
        String name = (String)value;
        if (name.startsWith("comparator-")) {
            String comparatorName = name.substring(Constants.COMPARATOR_PREFIX_LENGTH);
            if (!this.comparatorManager.isSupported(comparatorName)) throw new SieveException("Comparator " + comparatorName + " is not supported");
            this.declaredComparators.add(comparatorName);
            return;
        }
        try {
            this.commandManager.getCommand(name);
            return;
        }
        catch (LookupException e) {
            this.testManager.getTest(name);
        }
    }

    public Object visit(ASTstring_list node, Object data) throws SieveException {
        return this.visitNode(node, data);
    }
}

