/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.commands.extensions;

import java.util.List;
import java.util.ListIterator;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.commands.AbstractCommand;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;

public class Log
extends AbstractCommand {
    protected Object executeBasic(MailAdapter mail, Arguments arguments, Block block, SieveContext context) throws SieveException {
        List<String> strings;
        Argument argument;
        String logLevel = null;
        String message = null;
        ListIterator<Argument> argumentsIter = arguments.getArgumentList().listIterator();
        boolean stop = false;
        while (!stop && argumentsIter.hasNext()) {
            argument = argumentsIter.next();
            if (argument instanceof TagArgument) {
                String tag = ((TagArgument)argument).getTag();
                if (null == logLevel && (tag.equals(":fatal") || tag.equals(":error") || tag.equals(":warn") || tag.equals(":info") || tag.equals(":debug") || tag.equals(":trace"))) {
                    logLevel = tag;
                    continue;
                }
                throw context.getCoordinate().syntaxException("Found unexpected TagArgument");
            }
            argumentsIter.previous();
            stop = true;
        }
        if (argumentsIter.hasNext() && (argument = argumentsIter.next()) instanceof StringListArgument && 1 == (strings = ((StringListArgument)argument).getList()).size()) {
            message = strings.get(0);
        }
        if (null == message) {
            throw context.getCoordinate().syntaxException("Expecting a String");
        }
        if (argumentsIter.hasNext()) {
            throw context.getCoordinate().syntaxException("Found unexpected arguments");
        }
        this.log(null == logLevel ? ":info" : logLevel, message, context);
        return null;
    }

    protected void log(String logLevel, String message, SieveContext context) throws SyntaxException {
        if (logLevel.equals(":info")) {
            this.logInfo(message, context);
        } else if (logLevel.equals(":error")) {
            this.logError(message, context);
        } else if (logLevel.equals(":warn")) {
            this.logWarn(message, context);
        } else if (logLevel.equals(":debug")) {
            this.logDebug(message, context);
        } else if (logLevel.equals(":fatal")) {
            this.logFatal(message, context);
        } else if (logLevel.equals(":trace")) {
            this.logTrace(message, context);
        } else {
            throw context.getCoordinate().syntaxException(new StringBuilder("Unsupported logging level: ").append(logLevel));
        }
    }

    protected void logFatal(String message, SieveContext sieveContext) {
        org.apache.commons.logging.Log log = sieveContext.getLog();
        if (log.isFatalEnabled()) {
            log.fatal((Object)message);
        }
    }

    protected void logWarn(String message, SieveContext context) {
        org.apache.commons.logging.Log log = context.getLog();
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
    }

    protected void logInfo(String message, SieveContext context) {
        org.apache.commons.logging.Log log = context.getLog();
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
    }

    protected void logDebug(String message, SieveContext context) {
        org.apache.commons.logging.Log log = context.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }

    protected void logTrace(String message, SieveContext context) {
        org.apache.commons.logging.Log log = context.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)message);
        }
    }

    protected void logError(String message, SieveContext context) {
        org.apache.commons.logging.Log log = context.getLog();
        if (log.isErrorEnabled()) {
            log.error((Object)message);
        }
    }

    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
    }
}

