/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.lifecycle.api.Configurable;

public class XMLDomainList
extends AbstractDomainList
implements Configurable {
    private List<String> domainNames = new ArrayList<String>();
    private boolean managementDisabled = false;

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        super.configure(config);
        List serverNameConfs = config.getList("domainnames.domainname");
        for (int i = 0; i < serverNameConfs.size(); ++i) {
            try {
                this.addDomain((String)serverNameConfs.get(i));
                continue;
            }
            catch (DomainListException e) {
                throw new ConfigurationException("Unable to add domain to memory", (Throwable)e);
            }
        }
        this.managementDisabled = true;
    }

    protected List<String> getDomainListInternal() {
        return new ArrayList<String>(this.domainNames);
    }

    public boolean containsDomain(String domains) throws DomainListException {
        return this.domainNames.contains(domains);
    }

    public void addDomain(String domain) throws DomainListException {
        if (this.managementDisabled) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        String newDomain = domain.toLowerCase(Locale.US);
        if (!this.containsDomain(newDomain)) {
            this.domainNames.add(newDomain);
        }
    }

    public void removeDomain(String domain) throws DomainListException {
        if (this.managementDisabled) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        this.domainNames.remove(domain.toLowerCase(Locale.US));
    }
}

