/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.core.MimeMessageWrapper;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailrepository.file.MimeMessageStreamRepositorySource;
import org.apache.james.mailrepository.lib.AbstractMailRepository;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentObjectRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.mailet.Mail;

public class FileMailRepository
extends AbstractMailRepository {
    private FilePersistentStreamRepository streamRepository;
    private FilePersistentObjectRepository objectRepository;
    private String destination;
    private Set keys;
    private boolean fifo;
    private boolean cacheKeys;
    private FileSystem fs;

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        super.doConfigure(config);
        this.destination = config.getString("[@destinationURL]");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("FileMailRepository.destinationURL: " + this.destination);
        }
        this.fifo = config.getBoolean("[@FIFO]", false);
        this.cacheKeys = config.getBoolean("[@CACHEKEYS]", true);
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            DefaultConfigurationBuilder reposConfiguration = new DefaultConfigurationBuilder();
            reposConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            this.objectRepository = new FilePersistentObjectRepository();
            this.objectRepository.setLog(this.getLogger());
            this.objectRepository.setFileSystem(this.fs);
            this.objectRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.objectRepository.init();
            this.streamRepository = new FilePersistentStreamRepository();
            this.streamRepository.setLog(this.getLogger());
            this.streamRepository.setFileSystem(this.fs);
            this.streamRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.streamRepository.init();
            if (this.cacheKeys) {
                this.keys = Collections.synchronizedSet(new HashSet());
            }
            HashSet streamKeys = new HashSet();
            Iterator i = this.streamRepository.list();
            while (i.hasNext()) {
                streamKeys.add(i.next());
            }
            HashSet objectKeys = new HashSet();
            Iterator i2 = this.objectRepository.list();
            while (i2.hasNext()) {
                objectKeys.add(i2.next());
            }
            Collection strandedStreams = (Collection)streamKeys.clone();
            strandedStreams.removeAll(objectKeys);
            for (String key : strandedStreams) {
                this.remove(key);
            }
            Collection strandedObjects = (Collection)objectKeys.clone();
            strandedObjects.removeAll(streamKeys);
            for (String key : strandedObjects) {
                this.remove(key);
            }
            if (this.keys != null) {
                this.keys.clear();
                Iterator i3 = this.objectRepository.list();
                while (i3.hasNext()) {
                    this.keys.add(i3.next());
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer logBuffer = new StringBuffer(128).append(((Object)((Object)this)).getClass().getName()).append(" created in ").append(this.destination);
                this.getLogger().debug(logBuffer.toString());
            }
        }
        catch (Exception e) {
            String message = "Failed to retrieve Store component:" + e.getMessage();
            this.getLogger().error(message, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStore(Mail mc) throws MessagingException, IOException {
        String key = mc.getName();
        if (this.keys != null && !this.keys.contains(key)) {
            this.keys.add(key);
        }
        boolean saveStream = true;
        boolean update = true;
        MimeMessage message = mc.getMessage();
        if (message instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy messageCow = (MimeMessageCopyOnWriteProxy)message;
            message = messageCow.getWrappedMessage();
        }
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            StringBuffer destinationBuffer = new StringBuffer(128).append(this.destination).append("/").append(mc.getName());
            if (destinationBuffer.toString().equals(wrapper.getSourceId())) {
                if (!wrapper.isModified()) {
                    saveStream = false;
                }
                update = true;
            }
        }
        if (saveStream) {
            OutputStream out = null;
            try {
                if (update && message instanceof MimeMessageWrapper) {
                    ((MimeMessageWrapper)message).loadMessage();
                    out = this.streamRepository.put(key);
                    ((MimeMessageWrapper)message).writeTo(out, out, null, true);
                } else {
                    out = this.streamRepository.put(key);
                    mc.getMessage().writeTo(out);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        this.objectRepository.put(key, (Object)mc);
    }

    public Mail retrieve(String key) throws MessagingException {
        try {
            Mail mc = null;
            try {
                mc = (Mail)this.objectRepository.get(key);
            }
            catch (RuntimeException re) {
                StringBuffer exceptionBuffer = new StringBuffer(128);
                if (re.getCause() instanceof Error) {
                    exceptionBuffer.append("Error when retrieving mail, not deleting: ").append(re.toString());
                } else {
                    exceptionBuffer.append("Exception retrieving mail: ").append(re.toString()).append(", so we're deleting it.");
                    this.remove(key);
                }
                String errorMessage = exceptionBuffer.toString();
                this.getLogger().warn(errorMessage);
                this.getLogger().debug(errorMessage, (Throwable)re);
                return null;
            }
            MimeMessageStreamRepositorySource source = new MimeMessageStreamRepositorySource((StreamRepository)this.streamRepository, this.destination, key);
            mc.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)source));
            return mc;
        }
        catch (Exception me) {
            this.getLogger().error("Exception retrieving mail: " + me);
            throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
        }
    }

    protected void internalRemove(String key) throws MessagingException {
        if (this.keys != null) {
            this.keys.remove(key);
        }
        this.streamRepository.remove(key);
        this.objectRepository.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator list() {
        ArrayList clone;
        if (this.keys != null) {
            Set set = this.keys;
            synchronized (set) {
                clone = new ArrayList(this.keys);
            }
        } else {
            clone = new ArrayList();
            Iterator i = this.objectRepository.list();
            while (i.hasNext()) {
                clone.add(i.next());
            }
        }
        if (this.fifo) {
            Collections.sort(clone);
        }
        return clone.iterator();
    }
}

