/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;

public class MimeMessageStreamRepositorySource
extends MimeMessageSource {
    StreamRepository sr = null;
    String repositoryName = null;
    String key = null;
    private long size = -1L;

    public MimeMessageStreamRepositorySource(StreamRepository sr, String repositoryName, String key) {
        this.sr = sr;
        this.repositoryName = repositoryName;
        this.key = key;
    }

    public String getSourceId() {
        StringBuffer sourceIdBuffer = new StringBuffer(128).append(this.repositoryName).append("/").append(this.key);
        return sourceIdBuffer.toString();
    }

    public InputStream getInputStream() throws IOException {
        return this.sr.get(this.key);
    }

    public long getMessageSize() throws IOException {
        if (this.size == -1L) {
            this.size = this.sr instanceof FilePersistentStreamRepository ? ((FilePersistentStreamRepository)this.sr).getSize(this.key) : super.getMessageSize();
        }
        return this.size;
    }
}

