/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.file;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;

public class XMLRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private Map<String, String> mappings;

    protected void doConfigure(HierarchicalConfiguration arg0) throws ConfigurationException {
        List mapConf = arg0.getList("mapping");
        this.mappings = new HashMap<String, String>();
        if (mapConf != null && mapConf.size() > 0) {
            for (int i = 0; i < mapConf.size(); ++i) {
                this.mappings.putAll(RecipientRewriteTableUtil.getXMLMappings((String)((String)mapConf.get(i))));
            }
        } else {
            throw new ConfigurationException("No mapping configured");
        }
    }

    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        if (this.mappings == null) {
            return null;
        }
        return RecipientRewriteTableUtil.getTargetString((String)user, (String)domain, this.mappings);
    }

    protected Collection<String> getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        if (this.mappings == null) {
            return null;
        }
        String maps = this.mappings.get(user + "@" + domain);
        if (maps != null) {
            return RecipientRewriteTableUtil.mappingToCollection((String)maps);
        }
        return null;
    }

    protected Map<String, Collection<String>> getAllMappingsInternal() throws RecipientRewriteTableException {
        if (this.mappings != null && this.mappings.size() > 0) {
            HashMap<String, Collection<String>> mappingsNew = new HashMap<String, Collection<String>>();
            for (String key : this.mappings.keySet()) {
                mappingsNew.put(key, RecipientRewriteTableUtil.mappingToCollection((String)this.mappings.get(key).toString()));
            }
            return mappingsNew;
        }
        return null;
    }

    protected void addMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }
}

