/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.file;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.repository.file.FilePersistentObjectRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;

@Deprecated
public class UsersFileRepository
extends AbstractJamesUsersRepository {
    protected static boolean DEEP_DEBUG = false;
    private FilePersistentObjectRepository objectRepository;
    private static String urlSeparator = "/";
    private String destination;
    private FileSystem fs;

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.destination = configuration.getString("destination.[@URL]");
        if (!this.destination.endsWith(urlSeparator)) {
            this.destination = this.destination + urlSeparator;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            DefaultConfigurationBuilder objectConfiguration = new DefaultConfigurationBuilder();
            objectConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            this.objectRepository = new FilePersistentObjectRepository();
            this.objectRepository.setLog(this.getLogger());
            this.objectRepository.setFileSystem(this.fs);
            this.objectRepository.configure((HierarchicalConfiguration)objectConfiguration);
            this.objectRepository.init();
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer logBuffer = new StringBuffer(192).append(((Object)((Object)this)).getClass().getName()).append(" created in ").append(this.destination);
                this.getLogger().debug(logBuffer.toString());
            }
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Failed to initialize repository:" + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public Iterator<String> list() {
        return this.objectRepository.list();
    }

    protected void doAddUser(User user) throws UsersRepositoryException {
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Exception caught while storing user: " + e);
        }
    }

    public synchronized User getUserByName(String name) throws UsersRepositoryException {
        if (this.ignoreCase && (name = this.getRealName(name)) == null) {
            return null;
        }
        if (this.contains(name)) {
            try {
                return (User)this.objectRepository.get(name);
            }
            catch (Exception e) {
                throw new UsersRepositoryException("Exception while retrieving user: " + e.getMessage());
            }
        }
        return null;
    }

    public String getRealName(String name, boolean ignoreCase) throws UsersRepositoryException {
        if (ignoreCase) {
            Iterator<String> it = this.list();
            while (it.hasNext()) {
                String temp = it.next();
                if (!name.equalsIgnoreCase(temp)) continue;
                return temp;
            }
            return null;
        }
        return this.objectRepository.containsKey(name) ? name : null;
    }

    public String getRealName(String name) throws UsersRepositoryException {
        return this.getRealName(name, this.ignoreCase);
    }

    public void doUpdateUser(User user) throws UsersRepositoryException {
        try {
            this.objectRepository.put(user.getUserName(), (Object)user);
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Exception caught while storing user: " + e);
        }
    }

    public synchronized void removeUser(String name) throws UsersRepositoryException {
        this.objectRepository.remove(name);
    }

    public boolean contains(String name) throws UsersRepositoryException {
        if (this.ignoreCase) {
            return this.containsCaseInsensitive(name);
        }
        return this.objectRepository.containsKey(name);
    }

    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user;
        try {
            user = this.getUserByName(name);
            if (user == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception retrieving User" + e);
        }
        return user.verifyPassword(password);
    }

    public int countUsers() throws UsersRepositoryException {
        int count = 0;
        Iterator<String> it = this.list();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }
}

