/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.james.cli.probe.impl.JmxServerProbe;
import org.apache.james.cli.type.CmdType;

public class ServerCmd {
    private static final String HOST_OPT_LONG = "host";
    private static final String HOST_OPT_SHORT = "h";
    private static final String PORT_OPT_LONG = "port";
    private static final String PORT_OPT_SHORT = "p";
    private static final int defaultPort = 9999;
    private static Options options = null;

    public static void main(String[] args) throws IOException, InterruptedException, ParseException {
        long start = Calendar.getInstance().getTimeInMillis();
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException parseExcep) {
            System.err.println((Object)parseExcep);
            ServerCmd.printUsage();
            System.exit(1);
        }
        if (cmd.getArgs().length < 1) {
            System.err.println("Missing argument for command.");
            ServerCmd.printUsage();
            System.exit(1);
        }
        String host = cmd.getOptionValue(HOST_OPT_LONG);
        int port = 9999;
        String portNum = cmd.getOptionValue(PORT_OPT_LONG);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        }
        JmxServerProbe probe = null;
        try {
            probe = new JmxServerProbe(host, port);
        }
        catch (IOException ioe) {
            System.err.println("Error connecting to remote JMX agent!");
            ioe.printStackTrace();
            System.exit(3);
        }
        ServerCmd sCmd = new ServerCmd();
        String[] arguments = cmd.getArgs();
        String cmdName = arguments[0];
        CmdType cmdType = null;
        try {
            cmdType = CmdType.lookup(cmdName);
            if (CmdType.ADDUSER.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.addUser(arguments[1], arguments[2]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.REMOVEUSER.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.removeUser(arguments[1]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.LISTUSERS.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    sCmd.print(probe.listUsers(), System.out);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.ADDDOMAIN.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.addDomain(arguments[1]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.REMOVEDOMAIN.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.removeDomain(arguments[1]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.LISTDOMAINS.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    sCmd.print(probe.listDomains(), System.out);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.LISTMAPPINGS.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    sCmd.print(probe.listMappings(), System.out);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.LISTUSERDOMAINMAPPINGS.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    sCmd.print(probe.listUserDomainMappings(arguments[1], arguments[2]).toArray(new String[0]), System.out);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.ADDADDRESSMAPPING.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.addAddressMapping(arguments[1], arguments[2], arguments[3]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.REMOVEADDRESSMAPPING.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.removeAddressMapping(arguments[1], arguments[2], arguments[3]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.ADDREGEXMAPPING.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.addRegexMapping(arguments[1], arguments[2], arguments[3]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else if (CmdType.REMOVEREGEXMAPPING.equals((Object)cmdType)) {
                if (cmdType.hasCorrectArguments(arguments.length)) {
                    probe.removeRegexMapping(arguments[1], arguments[2], arguments[3]);
                } else {
                    ServerCmd.printUsage();
                    System.exit(1);
                }
            } else {
                System.err.println("Unrecognized command: " + cmdName + ".");
                ServerCmd.printUsage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            sCmd.onException(e, System.err);
            System.exit(1);
        }
        sCmd.print(new String[]{cmdType.getCommand() + " command executed sucessfully in " + (Calendar.getInstance().getTimeInMillis() - start) + " ms."}, System.out);
        System.exit(0);
    }

    public void print(String[] data, PrintStream out) {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            String u = data[i];
            out.println(u);
        }
        out.println();
    }

    public void print(Map<String, Collection<String>> map, PrintStream out) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            out.print(entry.getKey());
            out.print("=");
            out.println(entry.getValue().toString());
        }
        out.println();
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = String.format("%nAvailable commands:%nadduser <username> <password>%nremoveuser <username>%nlistusers%nadddomain <domainname>%nremovedomain <domainname>%nlistdomains%naddAddressMapping <user> <domain> <fromaddress>%nremoveAddressMapping <user> <domain> <fromaddress>%naddRegexMapping <user> <domain> <regex>%nremoveRegexMapping <user> <domain> <regex>%nlistuserdomainmappings <user> <domain>%nlistmappings%n", new Object[0]);
        String usage = String.format("java %s --host <arg> <command>%n", ServerCmd.class.getName());
        hf.printHelp(usage, "", options, header);
    }

    private void onException(Exception e, PrintStream out) {
        out.println("Error while execute command:");
        out.println(e.getMessage());
    }

    static {
        options = new Options();
        Option optHost = new Option(HOST_OPT_SHORT, HOST_OPT_LONG, true, "node hostname or ip address");
        optHost.setRequired(true);
        options.addOption(optHost);
        options.addOption(PORT_OPT_SHORT, PORT_OPT_LONG, true, "remote jmx agent port number");
    }
}

