/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.james.cli.probe.ServerProbe;
import org.apache.james.domainlist.api.DomainListManagementMBean;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.user.api.UsersRepositoryManagementMBean;

public class JmxServerProbe
implements ServerProbe {
    private static final String DOMAINLIST_OBJECT_NAME = "org.apache.james:type=component,name=domainlist";
    private static final String VIRTUALUSERTABLE_OBJECT_NAME = "org.apache.james:type=component,name=recipientrewritetable";
    private static final String USERSREPOSITORY_OBJECT_NAME = "org.apache.james:type=component,name=usersrepository";
    private MBeanServerConnection mbeanServerConn;
    private DomainListManagementMBean domainListProcxy;
    private RecipientRewriteTableManagementMBean virtualUserTableProxy;
    private UsersRepositoryManagementMBean usersRepositoryProxy;
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final int defaultPort = 9999;
    private String host;
    private int port;

    public JmxServerProbe(String host, int port) throws IOException, InterruptedException {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public JmxServerProbe(String host) throws IOException, InterruptedException {
        this.host = host;
        this.port = 9999;
        this.connect();
    }

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        JMXConnector jmxc = JMXConnectorFactory.connect(jmxUrl, null);
        this.mbeanServerConn = jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(DOMAINLIST_OBJECT_NAME);
            this.domainListProcxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServerConn, name, DomainListManagementMBean.class, true);
            name = new ObjectName(VIRTUALUSERTABLE_OBJECT_NAME);
            this.virtualUserTableProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServerConn, name, RecipientRewriteTableManagementMBean.class, true);
            name = new ObjectName(USERSREPOSITORY_OBJECT_NAME);
            this.usersRepositoryProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServerConn, name, UsersRepositoryManagementMBean.class, true);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
    }

    @Override
    public void addUser(String userName, String password) throws Exception {
        this.usersRepositoryProxy.addUser(userName, password);
    }

    @Override
    public void removeUser(String username) throws Exception {
        this.usersRepositoryProxy.deleteUser(username);
    }

    @Override
    public String[] listUsers() throws Exception {
        return this.usersRepositoryProxy.listAllUsers();
    }

    @Override
    public void setPassword(String userName, String password) throws Exception {
        this.usersRepositoryProxy.setPassword(userName, password);
    }

    @Override
    public void addDomain(String domain) throws Exception {
        this.domainListProcxy.addDomain(domain);
    }

    @Override
    public void removeDomain(String domain) throws Exception {
        this.domainListProcxy.removeDomain(domain);
    }

    @Override
    public String[] listDomains() throws Exception {
        return this.domainListProcxy.getDomains();
    }

    @Override
    public Map<String, Collection<String>> listMappings() throws Exception {
        return this.virtualUserTableProxy.getAllMappings();
    }

    @Override
    public void addAddressMapping(String user, String domain, String toAddress) throws Exception {
        this.virtualUserTableProxy.addAddressMapping(user, domain, toAddress);
    }

    @Override
    public void removeAddressMapping(String user, String domain, String fromAddress) throws Exception {
        this.virtualUserTableProxy.removeAddressMapping(user, domain, fromAddress);
    }

    @Override
    public Collection<String> listUserDomainMappings(String user, String domain) throws Exception {
        return this.virtualUserTableProxy.getUserDomainMappings(user, domain);
    }

    @Override
    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        this.virtualUserTableProxy.addRegexMapping(user, domain, regex);
    }

    @Override
    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        this.virtualUserTableProxy.removeRegexMapping(user, domain, regex);
    }
}

