/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.type;

public enum CmdType {
    ADDUSER("adduser", 3),
    REMOVEUSER("removeuser", 2),
    LISTUSERS("listusers", 1),
    ADDDOMAIN("adddomain", 2),
    REMOVEDOMAIN("removedomain", 2),
    LISTDOMAINS("listdomains", 1),
    LISTMAPPINGS("listmappings", 1),
    LISTUSERDOMAINMAPPINGS("listuserdomainmappings", 3),
    ADDADDRESSMAPPING("addaddressmapping", 4),
    REMOVEADDRESSMAPPING("removeaddressmapping", 4),
    ADDREGEXMAPPING("addregexmapping", 4),
    REMOVEREGEXMAPPING("removeregexmapping", 4);

    private String command;
    private int arguments;

    private CmdType(String command, int arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    public boolean hasCorrectArguments(int arguments) {
        return this.arguments == arguments;
    }

    public static CmdType lookup(String command) {
        if (command != null) {
            for (CmdType cmd : CmdType.values()) {
                if (!cmd.getCommand().equalsIgnoreCase(command)) continue;
                return cmd;
            }
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public int getArguments() {
        return this.arguments;
    }
}

