/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.broker.scheduler.JobLocation;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerImpl;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.index.BTreeIndex;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.PageFile;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.IntegerMarshaller;
import org.apache.kahadb.util.LockFile;
import org.apache.kahadb.util.Marshaller;
import org.apache.kahadb.util.StringMarshaller;
import org.apache.kahadb.util.VariableMarshaller;

public class JobSchedulerStore
extends ServiceSupport {
    static final Log LOG = LogFactory.getLog(JobSchedulerStore.class);
    private static final int DATABASE_LOCKED_WAIT_DELAY = 10000;
    public static final int CLOSED_STATE = 1;
    public static final int OPEN_STATE = 2;
    private File directory;
    PageFile pageFile;
    private Journal journal;
    private LockFile lockFile;
    private boolean failIfDatabaseIsLocked;
    private int journalMaxFileLength = 0x2000000;
    private int journalMaxWriteBatchSize = 0x400000;
    private boolean enableIndexWriteAsync = false;
    MetaData metaData = new MetaData(this);
    final MetaDataMarshaller metaDataMarshaller = new MetaDataMarshaller(this);
    Map<String, JobSchedulerImpl> schedulers = new HashMap<String, JobSchedulerImpl>();

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public long size() {
        if (!this.isStarted()) {
            return 0L;
        }
        try {
            return this.journal.getDiskSize() + this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JobScheduler getJobScheduler(final String name) throws Exception {
        JobSchedulerImpl result = this.schedulers.get(name);
        if (result == null) {
            final JobSchedulerImpl js = new JobSchedulerImpl(this);
            js.setName(name);
            this.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    js.createIndexes(tx);
                    js.load(tx);
                    JobSchedulerStore.this.metaData.storedSchedulers.put(tx, (Object)name, (Object)js);
                }
            });
            result = js;
            this.schedulers.put(name, js);
            if (this.isStarted()) {
                result.start();
            }
            this.pageFile.flush();
        }
        return result;
    }

    public synchronized boolean removeJobScheduler(final String name) throws Exception {
        boolean result = false;
        final JobSchedulerImpl js = this.schedulers.remove(name);
        boolean bl = result = js != null;
        if (result) {
            js.stop();
            this.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    JobSchedulerStore.this.metaData.storedSchedulers.remove(tx, (Object)name);
                    js.destroy(tx);
                }
            });
        }
        return result;
    }

    protected synchronized void doStart() throws Exception {
        if (this.directory == null) {
            this.directory = new File(IOHelper.getDefaultDataDirectory() + File.pathSeparator + "delayedDB");
        }
        IOHelper.mkdirs(this.directory);
        this.lock();
        this.journal = new Journal();
        this.journal.setDirectory(this.directory);
        this.journal.setMaxFileLength(this.getJournalMaxFileLength());
        this.journal.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        this.journal.start();
        this.pageFile = new PageFile(this.directory, "scheduleDB");
        this.pageFile.load();
        this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                Page page;
                if (JobSchedulerStore.this.pageFile.getPageCount() == 0L) {
                    page = tx.allocate();
                    assert (page.getPageId() == 0L);
                    page.set((Object)JobSchedulerStore.this.metaData);
                    JobSchedulerStore.this.metaData.page = page;
                    JobSchedulerStore.this.metaData.createIndexes(tx);
                    tx.store(JobSchedulerStore.this.metaData.page, (Marshaller)JobSchedulerStore.this.metaDataMarshaller, true);
                } else {
                    page = tx.load(0L, (Marshaller)JobSchedulerStore.this.metaDataMarshaller);
                    JobSchedulerStore.this.metaData = (MetaData)page.get();
                    JobSchedulerStore.this.metaData.page = page;
                }
                JobSchedulerStore.this.metaData.load(tx);
                JobSchedulerStore.this.metaData.loadScheduler(tx, JobSchedulerStore.this.schedulers);
                for (JobSchedulerImpl js : JobSchedulerStore.this.schedulers.values()) {
                    try {
                        js.start();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to load " + js.getName()), (Throwable)e);
                    }
                }
            }
        });
        this.pageFile.flush();
        LOG.info((Object)(this + " started"));
    }

    protected synchronized void doStop(ServiceStopper stopper) throws Exception {
        for (JobSchedulerImpl js : this.schedulers.values()) {
            js.stop();
        }
        if (this.pageFile != null) {
            this.pageFile.unload();
        }
        if (this.journal != null) {
            this.journal.close();
        }
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
        this.lockFile = null;
        LOG.info((Object)(this + " stopped"));
    }

    synchronized void incrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        Integer val = (Integer)this.metaData.journalRC.get(tx, (Object)logId);
        int refCount = val != null ? val + 1 : 1;
        this.metaData.journalRC.put(tx, (Object)logId, (Object)refCount);
    }

    synchronized void decrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        int refCount = (Integer)this.metaData.journalRC.get(tx, (Object)logId);
        if (--refCount <= 0) {
            this.metaData.journalRC.remove(tx, (Object)logId);
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(logId);
            this.journal.removeDataFiles(set);
        } else {
            this.metaData.journalRC.put(tx, (Object)logId, (Object)refCount);
        }
    }

    synchronized ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        ByteSequence result = null;
        result = this.journal.read(location);
        return result;
    }

    synchronized Location write(ByteSequence payload, boolean sync) throws IllegalStateException, IOException {
        return this.journal.write(payload, sync);
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Database " + lockFileName + " is locked... waiting " + 10 + " seconds for the database to be unlocked. Reason: " + e));
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    PageFile getPageFile() {
        this.pageFile.isLoaded();
        return this.pageFile;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    public String toString() {
        return "JobSchedulerStore:" + this.directory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JobSchedulerMarshaller
    extends VariableMarshaller<JobSchedulerImpl> {
        private final JobSchedulerStore store;

        JobSchedulerMarshaller(JobSchedulerStore store) {
            this.store = store;
        }

        public JobSchedulerImpl readPayload(DataInput dataIn) throws IOException {
            JobSchedulerImpl result = new JobSchedulerImpl(this.store);
            result.read(dataIn);
            return result;
        }

        public void writePayload(JobSchedulerImpl js, DataOutput dataOut) throws IOException {
            js.write(dataOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueMarshaller
    extends VariableMarshaller<List<JobLocation>> {
        ValueMarshaller() {
        }

        public List<JobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<JobLocation> result = new ArrayList<JobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                JobLocation jobLocation = new JobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        public void writePayload(List<JobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (JobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetaDataMarshaller
    extends VariableMarshaller<MetaData> {
        private final JobSchedulerStore store;

        MetaDataMarshaller(JobSchedulerStore store) {
            this.store = store;
        }

        public MetaData readPayload(DataInput dataIn) throws IOException {
            MetaData rc = new MetaData(this.store);
            rc.read(dataIn);
            return rc;
        }

        public void writePayload(MetaData object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetaData {
        private final JobSchedulerStore store;
        Page<MetaData> page;
        BTreeIndex<Integer, Integer> journalRC;
        BTreeIndex<String, JobSchedulerImpl> storedSchedulers;

        protected MetaData(JobSchedulerStore store) {
            this.store = store;
        }

        void createIndexes(Transaction tx) throws IOException {
            this.storedSchedulers = new BTreeIndex(JobSchedulerStore.this.pageFile, tx.allocate().getPageId());
            this.journalRC = new BTreeIndex(JobSchedulerStore.this.pageFile, tx.allocate().getPageId());
        }

        void load(Transaction tx) throws IOException {
            this.storedSchedulers.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller((Marshaller)new JobSchedulerMarshaller(this.store));
            this.storedSchedulers.load(tx);
            this.journalRC.setKeyMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.load(tx);
        }

        void loadScheduler(Transaction tx, Map<String, JobSchedulerImpl> schedulers) throws IOException {
            Iterator i = this.storedSchedulers.iterator(tx);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                ((JobSchedulerImpl)entry.getValue()).load(tx);
                schedulers.put((String)entry.getKey(), (JobSchedulerImpl)entry.getValue());
            }
        }

        public void read(DataInput is) throws IOException {
            this.storedSchedulers = new BTreeIndex(JobSchedulerStore.this.pageFile, is.readLong());
            this.storedSchedulers.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller((Marshaller)new JobSchedulerMarshaller(this.store));
            this.journalRC = new BTreeIndex(JobSchedulerStore.this.pageFile, is.readLong());
            this.journalRC.setKeyMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
        }

        public void write(DataOutput os) throws IOException {
            os.writeLong(this.storedSchedulers.getPageId());
            os.writeLong(this.journalRC.getPageId());
        }
    }
}

