/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Endpoint;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeDemandForwardingBridge
extends DemandForwardingBridgeSupport {
    private static final Log LOG = LogFactory.getLog(CompositeDemandForwardingBridge.class);
    protected final BrokerId[] remoteBrokerPath = new BrokerId[]{null};
    protected Object brokerInfoMutex = new Object();

    public CompositeDemandForwardingBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
        this.remoteBrokerName = remoteBroker.toString();
        this.remoteBrokerNameKnownLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteBrokerInfo(Command command) throws IOException {
        Object object = this.brokerInfoMutex;
        synchronized (object) {
            BrokerInfo remoteBrokerInfo = (BrokerInfo)command;
            BrokerId remoteBrokerId = remoteBrokerInfo.getBrokerId();
            Endpoint from = command.getFrom();
            if (from == null) {
                LOG.warn((Object)("Incoming command does not have a from endpoint: " + command));
            } else {
                from.setBrokerInfo(remoteBrokerInfo);
            }
            if (this.localBrokerId != null && this.localBrokerId.equals(remoteBrokerId)) {
                LOG.info((Object)"Disconnecting loop back connection.");
                ServiceSupport.dispose(this);
            }
            if (!this.disposed.get()) {
                this.triggerLocalStartBridge();
            }
        }
    }

    protected void addRemoteBrokerToBrokerPath(ConsumerInfo info) throws IOException {
        info.setBrokerPath(this.appendToBrokerPath(info.getBrokerPath(), this.getFromBrokerId(info)));
    }

    protected BrokerId getFromBrokerId(Command command) throws IOException {
        BrokerId answer = null;
        Endpoint from = command.getFrom();
        if (from == null) {
            LOG.warn((Object)("Incoming command does not have a from endpoint: " + command));
        } else {
            answer = from.getBrokerId();
        }
        if (answer != null) {
            return answer;
        }
        throw new IOException("No broker ID is available for endpoint: " + from + " from command: " + command);
    }

    protected void serviceLocalBrokerInfo(Command command) throws InterruptedException {
    }

    protected NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo info) throws IOException {
        return new NetworkBridgeFilter(this.getFromBrokerId(info), this.configuration.getNetworkTTL());
    }

    protected BrokerId[] getRemoteBrokerPath() {
        return this.remoteBrokerPath;
    }
}

