/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.plugin.DiscardingDLQBroker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscardingDLQBrokerPlugin
implements BrokerPlugin {
    public static Log log = LogFactory.getLog(DiscardingDLQBrokerPlugin.class);
    private boolean dropTemporaryTopics = true;
    private boolean dropTemporaryQueues = true;
    private boolean dropAll = true;
    private String dropOnly;
    private int reportInterval = 1000;

    public Broker installPlugin(Broker broker) throws Exception {
        log.info((Object)("Installing Discarding Dead Letter Queue broker plugin[dropAll=" + this.isDropAll() + "; dropTemporaryTopics=" + this.isDropTemporaryTopics() + "; dropTemporaryQueues=" + this.isDropTemporaryQueues() + "; dropOnly=" + this.getDropOnly() + "; reportInterval=" + this.getReportInterval() + "]"));
        DiscardingDLQBroker cb = new DiscardingDLQBroker(broker);
        cb.setDropAll(this.isDropAll());
        cb.setDropTemporaryQueues(this.isDropTemporaryQueues());
        cb.setDropTemporaryTopics(this.isDropTemporaryTopics());
        cb.setDestFilter(this.getDestFilter());
        return cb;
    }

    public boolean isDropAll() {
        return this.dropAll;
    }

    public boolean isDropTemporaryQueues() {
        return this.dropTemporaryQueues;
    }

    public boolean isDropTemporaryTopics() {
        return this.dropTemporaryTopics;
    }

    public String getDropOnly() {
        return this.dropOnly;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public void setDropTemporaryTopics(boolean dropTemporaryTopics) {
        this.dropTemporaryTopics = dropTemporaryTopics;
    }

    public void setDropTemporaryQueues(boolean dropTemporaryQueues) {
        this.dropTemporaryQueues = dropTemporaryQueues;
    }

    public void setDropAll(boolean dropAll) {
        this.dropAll = dropAll;
    }

    public void setDropOnly(String dropOnly) {
        this.dropOnly = dropOnly;
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public Pattern[] getDestFilter() {
        if (this.getDropOnly() == null) {
            return null;
        }
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        StringTokenizer t = new StringTokenizer(this.getDropOnly(), " ");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(Pattern.compile(s));
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new Pattern[0]);
    }
}

